/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.nut;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.nut.DataItem;
import com.github.kokorin.jaffree.nut.FrameCode;
import com.github.kokorin.jaffree.nut.Info;
import com.github.kokorin.jaffree.nut.MainHeader;
import com.github.kokorin.jaffree.nut.NutConst;
import com.github.kokorin.jaffree.nut.NutFrame;
import com.github.kokorin.jaffree.nut.NutOutputStream;
import com.github.kokorin.jaffree.nut.StreamHeader;
import com.github.kokorin.jaffree.nut.SyncPoint;
import com.github.kokorin.jaffree.nut.Timestamp;
import com.github.kokorin.jaffree.nut.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NutWriter {
    private final NutOutputStream output;
    private final long frameOrderingBufferMillis;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private MainHeader mainHeader;
    private StreamHeader[] streamHeaders;
    private Info[] infos;
    private long[] lastPts;
    private boolean[] eor;
    private long lastSyncPointPosition = 0L;
    private boolean initialized = false;
    private boolean closed = false;
    private final List<TsFrame> frameOrderingBuffer = new ArrayList<TsFrame>();
    private static final long MAJOR_VERSION = 3L;
    private static final long MINOR_VERSION = 0L;

    public NutWriter(NutOutputStream output, long frameOrderingBufferMillis) {
        this.output = output;
        this.frameOrderingBufferMillis = frameOrderingBufferMillis;
    }

    public void setMainHeader(int streamCount, long maxDistance, Rational[] timebases, FrameCode[] frameCodes) {
        if (this.initialized) {
            throw new JaffreeException("NutWriter is already initialized!");
        }
        this.mainHeader = new MainHeader(3L, 0L, streamCount, maxDistance, timebases, frameCodes, new long[0], EnumSet.noneOf(MainHeader.Flag.class));
    }

    public void setStreamHeaders(StreamHeader[] streamHeaders) {
        if (this.initialized) {
            throw new JaffreeException("NutWriter is already initialized!");
        }
        this.streamHeaders = streamHeaders;
    }

    public void setInfos(Info[] infos) {
        if (this.initialized) {
            throw new JaffreeException("NutWriter is already initialized!");
        }
        this.infos = infos;
    }

    private void initialize() throws IOException {
        if (this.initialized) {
            return;
        }
        this.lastPts = new long[this.mainHeader.streamCount];
        this.eor = new boolean[this.mainHeader.streamCount];
        this.output.writeCString("nut/multimedia container");
        this.writeMainHeader();
        if (this.streamHeaders == null) {
            throw new JaffreeException("StreamHeaders must be specified before");
        }
        for (StreamHeader streamHeader : this.streamHeaders) {
            this.writeStreamHeader(streamHeader);
        }
        if (this.infos == null) {
            throw new IllegalArgumentException("Info array must be specified");
        }
        for (Info info : this.infos) {
            this.writeInfo(info);
        }
        this.writeSyncPoint();
        this.initialized = true;
    }

    private void writeMainHeader() throws IOException {
        Rational[] timeBases;
        if (this.mainHeader == null) {
            throw new JaffreeException("MainHeader must be specified before");
        }
        this.buffer.reset();
        NutOutputStream bufOutput = new NutOutputStream(this.buffer);
        bufOutput.writeValue(3L);
        bufOutput.writeValue(this.mainHeader.streamCount);
        bufOutput.writeValue(this.mainHeader.maxDistance);
        bufOutput.writeValue(this.mainHeader.timeBases.length);
        for (Rational timeBase : timeBases = this.mainHeader.timeBases) {
            bufOutput.writeValue(timeBase.getNumerator());
            bufOutput.writeValue(timeBase.getDenominator());
        }
        int streamId = 0;
        long ptsDelta = 0L;
        long dataSizeMul = 1L;
        int i = 0;
        while (i < 256) {
            int fields = 0;
            FrameCode frameCode = this.mainHeader.frameCodes[i];
            Set<FrameCode.Flag> flags = frameCode.flags;
            if (frameCode.ptsDelta != ptsDelta) {
                fields = 1;
            }
            ptsDelta = frameCode.ptsDelta;
            if ((long)frameCode.dataSizeMul != dataSizeMul) {
                fields = 2;
            }
            dataSizeMul = frameCode.dataSizeMul;
            if (frameCode.streamId != streamId) {
                fields = 3;
            }
            streamId = frameCode.streamId;
            if (frameCode.dataSizeLsb != 0) {
                fields = 4;
            }
            int size = frameCode.dataSizeLsb;
            int count = 0;
            while (i < 256) {
                if (i == 78) {
                    --count;
                } else {
                    boolean flagsAreEqual;
                    frameCode = this.mainHeader.frameCodes[i];
                    boolean bl = flagsAreEqual = frameCode.flags.containsAll(flags) && frameCode.flags.size() == flags.size();
                    if (!flagsAreEqual || frameCode.streamId != streamId || (long)frameCode.dataSizeMul != dataSizeMul || frameCode.dataSizeLsb != size + count || frameCode.ptsDelta != ptsDelta) break;
                }
                ++count;
                ++i;
            }
            if ((long)count != dataSizeMul - (long)size) {
                fields = 6;
            }
            bufOutput.writeValue(FrameCode.Flag.toBitCode(flags));
            bufOutput.writeValue(fields);
            if (fields > 0) {
                bufOutput.writeSignedValue(ptsDelta);
            }
            if (fields > 1) {
                bufOutput.writeValue(dataSizeMul);
            }
            if (fields > 2) {
                bufOutput.writeValue(streamId);
            }
            if (fields > 3) {
                bufOutput.writeValue(size);
            }
            if (fields > 4) {
                bufOutput.writeValue(0L);
            }
            if (fields <= 5) continue;
            bufOutput.writeValue(count);
        }
        bufOutput.writeValue(0L);
        bufOutput.writeValue(0L);
        bufOutput.flush();
        this.writePacket(NutConst.MAIN_STARTCODE, this.buffer.toByteArray());
    }

    private void writeStreamHeader(StreamHeader streamHeader) throws IOException {
        this.buffer.reset();
        NutOutputStream bufOutput = new NutOutputStream(this.buffer);
        bufOutput.writeValue(streamHeader.streamId);
        bufOutput.writeValue(streamHeader.streamType.code);
        bufOutput.writeVariableBytes(streamHeader.fourcc);
        bufOutput.writeValue(streamHeader.timeBaseId);
        bufOutput.writeValue(streamHeader.msbPtsShift);
        bufOutput.writeValue(streamHeader.maxPtsDistance);
        bufOutput.writeValue(streamHeader.decodeDelay);
        bufOutput.writeValue(StreamHeader.Flag.toBitCode(streamHeader.flags));
        bufOutput.writeVariableBytes(streamHeader.codecSpecificData);
        if (streamHeader.streamType == StreamHeader.Type.VIDEO) {
            bufOutput.writeValue(streamHeader.video.width);
            bufOutput.writeValue(streamHeader.video.height);
            bufOutput.writeValue(streamHeader.video.sampleWidth);
            bufOutput.writeValue(streamHeader.video.sampleHeight);
            bufOutput.writeValue(streamHeader.video.type.code);
        } else if (streamHeader.streamType == StreamHeader.Type.AUDIO) {
            bufOutput.writeValue(streamHeader.audio.sampleRate.getNumerator());
            bufOutput.writeValue(streamHeader.audio.sampleRate.getDenominator());
            bufOutput.writeValue(streamHeader.audio.channelCount);
        }
        bufOutput.flush();
        this.writePacket(NutConst.STREAM_STARTCODE, this.buffer.toByteArray());
    }

    public void writeFrame(NutFrame frame) throws IOException {
        TsFrame tsFrame;
        if (this.closed) {
            throw new JaffreeException("NutWriter is closed");
        }
        StreamHeader stream = this.streamHeaders[frame.streamId];
        Rational timestamp = this.mainHeader.timeBases[stream.timeBaseId].multiply(frame.pts);
        this.frameOrderingBuffer.add(new TsFrame(timestamp, frame));
        Collections.sort(this.frameOrderingBuffer, TsFrame.COMPARATOR);
        Rational lastFrameTimestamp = this.frameOrderingBuffer.get(this.frameOrderingBuffer.size() - 1).timestamp;
        Iterator<TsFrame> frameIterator = this.frameOrderingBuffer.iterator();
        while (frameIterator.hasNext() && !lastFrameTimestamp.subtract((tsFrame = frameIterator.next()).timestamp).lessThanOrEqual(new Rational(this.frameOrderingBufferMillis, 1000L))) {
            this.writeFrameInternal(tsFrame.frame);
            frameIterator.remove();
        }
    }

    private void writeFrameInternal(NutFrame frame) throws IOException {
        this.initialize();
        if (!frame.eor) {
            Rational maxTs = Rational.ZERO;
            for (int i = 0; i < this.mainHeader.timeBases.length; ++i) {
                Rational ts = this.mainHeader.timeBases[i].multiply(this.lastPts[i]);
                if (!ts.greaterThan(maxTs)) continue;
                maxTs = ts;
            }
            StreamHeader steam = this.streamHeaders[frame.streamId];
            Rational framedTs = this.mainHeader.timeBases[steam.timeBaseId].multiply(frame.pts);
            if (framedTs.lessThan(maxTs)) {
                throw new JaffreeException("Unordered frames! Try to increase frameOrderingBufferMillis. maxTs: " + maxTs + ", but current: " + framedTs);
            }
        }
        StreamHeader sc = this.streamHeaders[frame.streamId];
        int ftnum = -1;
        int size = 0;
        int msbPts = 1 << sc.msbPtsShift;
        Set<FrameCode.Flag> codedFlags = Collections.emptySet();
        long ptsDelta = frame.pts - this.lastPts[frame.streamId];
        boolean checksum = false;
        long codedPts = Math.abs(ptsDelta) < (long)(msbPts / 2 - 1) ? frame.pts & (long)(msbPts - 1) : frame.pts + (long)msbPts;
        if ((long)frame.data.length > 2L * this.mainHeader.maxDistance) {
            checksum = true;
        }
        if (Math.abs(ptsDelta) > sc.maxPtsDistance) {
            checksum = true;
        }
        for (int i = 0; i < 256; ++i) {
            Set<FrameCode.Flag> xor;
            int len = 1;
            FrameCode ft = this.mainHeader.frameCodes[i];
            Set<FrameCode.Flag> flags = ft.flags;
            if (flags.contains((Object)FrameCode.Flag.INVALID)) continue;
            EnumSet<FrameCode.Flag> fdFlags = EnumSet.noneOf(FrameCode.Flag.class);
            if (frame.keyframe) {
                fdFlags.add(FrameCode.Flag.KEYFRAME);
            }
            if (frame.eor) {
                fdFlags.add(FrameCode.Flag.EOR);
            }
            if (flags.contains((Object)FrameCode.Flag.CODED_FLAGS)) {
                flags = EnumSet.copyOf(fdFlags);
                if (ft.streamId != frame.streamId) {
                    flags.add(FrameCode.Flag.STREAM_ID);
                }
                if (ft.ptsDelta != ptsDelta) {
                    flags.add(FrameCode.Flag.CODED_PTS);
                }
                if (ft.dataSizeLsb != frame.data.length) {
                    flags.add(FrameCode.Flag.SIZE_MSB);
                }
                if (checksum) {
                    flags.add(FrameCode.Flag.CHECKSUM);
                }
                flags.add(FrameCode.Flag.CODED_FLAGS);
            }
            if ((xor = FrameCode.Flag.xor(flags, fdFlags)).contains((Object)FrameCode.Flag.KEYFRAME) || xor.contains((Object)FrameCode.Flag.EOR) || !flags.contains((Object)FrameCode.Flag.STREAM_ID) && ft.streamId != frame.streamId || !flags.contains((Object)FrameCode.Flag.CODED_PTS) && ft.ptsDelta != ptsDelta || (!flags.contains((Object)FrameCode.Flag.SIZE_MSB) ? ft.dataSizeLsb != frame.data.length : (frame.data.length - ft.dataSizeLsb) % ft.dataSizeMul != 0)) continue;
            if (!flags.contains((Object)FrameCode.Flag.CHECKSUM) && checksum) continue;
            if (flags.contains((Object)FrameCode.Flag.CODED_FLAGS)) {
                len += 8;
            }
            if (flags.contains((Object)FrameCode.Flag.STREAM_ID)) {
                len += 8;
            }
            if (flags.contains((Object)FrameCode.Flag.CODED_PTS)) {
                len += 8;
            }
            if (flags.contains((Object)FrameCode.Flag.SIZE_MSB)) {
                len += 8;
            }
            if (flags.contains((Object)FrameCode.Flag.CHECKSUM)) {
                len += 4;
            }
            if (size != 0 && len >= size) continue;
            ftnum = i;
            codedFlags = flags;
            size = len;
        }
        if (ftnum == -1) {
            throw new IllegalArgumentException("Can't find appropriate FrameCode for " + frame);
        }
        if (this.lastSyncPointPosition + this.mainHeader.maxDistance < this.output.getPosition() + (long)size + (long)frame.data.length) {
            this.writeSyncPoint();
        }
        this.output.resetCrc32();
        this.output.writeByte(ftnum);
        FrameCode ft = this.mainHeader.frameCodes[ftnum];
        if (codedFlags.contains((Object)FrameCode.Flag.CODED_FLAGS)) {
            Set<FrameCode.Flag> codedXor = FrameCode.Flag.xor(codedFlags, ft.flags);
            this.output.writeValue(FrameCode.Flag.toBitCode(codedXor));
        }
        if (codedFlags.contains((Object)FrameCode.Flag.STREAM_ID)) {
            this.output.writeValue(frame.streamId);
        }
        if (codedFlags.contains((Object)FrameCode.Flag.CODED_PTS)) {
            this.output.writeValue(codedPts);
        }
        if (codedFlags.contains((Object)FrameCode.Flag.SIZE_MSB)) {
            this.output.writeValue((frame.data.length - ft.dataSizeLsb) / ft.dataSizeMul);
        }
        if (codedFlags.contains((Object)FrameCode.Flag.CHECKSUM)) {
            this.output.writeCrc32();
        }
        this.output.writeBytes(frame.data);
        this.lastPts[frame.streamId] = frame.pts;
        this.eor[frame.streamId] = codedFlags.contains((Object)FrameCode.Flag.EOR);
    }

    public void writeFooter() throws IOException {
        for (TsFrame tsFrame : this.frameOrderingBuffer) {
            this.writeFrameInternal(tsFrame.frame);
        }
        this.frameOrderingBuffer.clear();
        for (int streamId = 0; streamId < this.eor.length; ++streamId) {
            if (this.eor[streamId]) continue;
            this.writeEorFrame(streamId);
        }
        for (TsFrame tsFrame : this.frameOrderingBuffer) {
            this.writeFrameInternal(tsFrame.frame);
        }
        this.frameOrderingBuffer.clear();
        this.writeMainHeader();
        for (StreamHeader streamHeader : this.streamHeaders) {
            this.writeStreamHeader(streamHeader);
        }
        this.writeSyncPoint();
        this.closed = true;
    }

    private void writeEorFrame(int streamId) throws IOException {
        NutFrame frame = new NutFrame(streamId, this.lastPts[streamId], new byte[0], null, null, true, true);
        this.writeFrame(frame);
    }

    private void writeInfo(Info info) throws IOException {
        this.buffer.reset();
        NutOutputStream bufOutput = new NutOutputStream(this.buffer);
        bufOutput.writeValue((long)info.streamId + 1L);
        bufOutput.writeSignedValue(info.chapterId);
        Timestamp timestamp = new Timestamp(info.timebaseId, info.chapterStartPts);
        bufOutput.writeTimestamp(this.mainHeader.timeBases.length, timestamp);
        bufOutput.writeValue(info.chapterLengthPts);
        this.writeDataItems(info.metaData, bufOutput);
        bufOutput.flush();
        this.writePacket(NutConst.INFO_STARTCODE, this.buffer.toByteArray());
    }

    private void writeSyncPoint() throws IOException {
        long maxPts = this.lastPts[0];
        int maxI = 0;
        for (int i = 1; i < this.mainHeader.timeBases.length; ++i) {
            long pts = Util.convertTimestamp(this.lastPts[i], this.mainHeader.timeBases[i], this.mainHeader.timeBases[maxI]);
            if (pts <= maxPts) continue;
            maxPts = this.lastPts[i];
            maxI = i;
        }
        Timestamp globalKeyPts = new Timestamp(maxI, maxPts);
        long backPtr = (this.output.getPosition() - this.lastSyncPointPosition) / 16L;
        SyncPoint syncPoint = new SyncPoint(globalKeyPts, backPtr);
        for (int i = 0; i < this.mainHeader.timeBases.length; ++i) {
            long pts;
            if (i == maxI) continue;
            this.lastPts[i] = pts = Util.convertTimestamp(maxPts, this.mainHeader.timeBases[maxI], this.mainHeader.timeBases[i]);
        }
        this.buffer.reset();
        NutOutputStream bufOutput = new NutOutputStream(this.buffer);
        bufOutput.writeTimestamp(this.mainHeader.timeBases.length, syncPoint.globalKeyPts);
        bufOutput.writeValue(syncPoint.backPtrDiv16);
        if (this.mainHeader.flags.contains((Object)MainHeader.Flag.BROADCAST_MODE)) {
            bufOutput.writeTimestamp(this.mainHeader.timeBases.length, syncPoint.transmitTs);
        }
        this.lastSyncPointPosition = this.output.getPosition();
        bufOutput.flush();
        this.writePacket(NutConst.SYNCPOINT_STARTCODE, this.buffer.toByteArray());
    }

    private void writeDataItems(DataItem[] items, NutOutputStream output) throws IOException {
        output.writeValue(items.length);
        block14: for (DataItem item : items) {
            output.writeVariablesString(item.name);
            switch (item.type) {
                case "UTF-8": {
                    output.writeSignedValue(-1L);
                    output.writeVariablesString((String)item.value);
                    continue block14;
                }
                case "s": {
                    output.writeSignedValue(-3L);
                    output.writeSignedValue(((Number)item.value).longValue());
                    continue block14;
                }
                case "t": {
                    output.writeSignedValue(-4L);
                    output.writeTimestamp(this.mainHeader.timeBases.length, (Timestamp)item.value);
                    continue block14;
                }
                case "r": {
                    Rational rational = (Rational)item.value;
                    output.writeSignedValue(-rational.getDenominator() - 4L);
                    output.writeSignedValue(rational.getNumerator());
                    continue block14;
                }
                case "v": {
                    long value = ((Number)item.value).longValue();
                    if (value < 0L) {
                        throw new IllegalArgumentException("Value with type 'v' must be non negative");
                    }
                    output.writeSignedValue(value);
                    continue block14;
                }
                default: {
                    output.writeSignedValue(-2L);
                    output.writeVariablesString(item.type);
                    output.writeVariableBytes((byte[])item.value);
                }
            }
        }
    }

    private void writePacket(long startcode, byte[] data) throws IOException {
        long forwardPtr = (long)data.length + 4L;
        this.output.resetCrc32();
        this.output.writeLong(startcode);
        this.output.writeValue(forwardPtr);
        if (forwardPtr > 4096L) {
            this.output.writeCrc32();
        }
        this.output.resetCrc32();
        this.output.writeBytes(data);
        this.output.writeCrc32();
        this.output.flush();
    }

    private static class TsFrame {
        private final Rational timestamp;
        private final NutFrame frame;
        static final Comparator<TsFrame> COMPARATOR = Comparator.comparing(ts -> ts.timestamp);

        TsFrame(Rational timestamp, NutFrame frame) {
            this.timestamp = timestamp;
            this.frame = frame;
        }
    }
}

