/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class SizeMultimapOperation
extends RetryOnFailureOperation<Long> {
    private final boolean supportsDuplicates;

    protected SizeMultimapOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, boolean supportsDuplicates) {
        super((short)113, (short)114, codec, channelFactory, cacheName, clientTopology, flags, cfg, null, null);
        this.supportsDuplicates = supportsDuplicates;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.sendHeaderAndRead(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.complete(ByteBufUtil.readVLong(buf));
    }

    @Override
    protected void sendHeaderAndRead(Channel channel) {
        this.scheduleRead(channel);
        this.sendHeader(channel);
    }

    @Override
    protected void sendHeader(Channel channel) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + this.codec.estimateSizeMultimapSupportsDuplicated());
        this.codec.writeHeader(buf, this.header);
        this.codec.writeMultimapSupportDuplicates(buf, this.supportsDuplicates);
        channel.writeAndFlush((Object)buf);
    }
}

