/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.BytesMessage;
import org.jgroups.Message;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.PartialOutputStream;

public class FragmentedMessage
extends BytesMessage {
    protected Message original_msg;

    public FragmentedMessage() {
    }

    public FragmentedMessage(Message original_msg, int off, int len) {
        this.original_msg = original_msg;
        this.offset = off;
        this.length = len;
    }

    public Message getOriginalMessage() {
        return this.original_msg;
    }

    @Override
    public short getType() {
        return 6;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    @Override
    public Supplier<Message> create() {
        return FragmentedMessage::new;
    }

    @Override
    protected int sizeOfPayload() {
        return 4 + this.length;
    }

    @Override
    protected Message copyPayload(Message copy) {
        FragmentedMessage msg = (FragmentedMessage)super.copyPayload(copy);
        msg.offset = this.offset;
        msg.length = this.length;
        msg.original_msg = this.original_msg;
        return msg;
    }

    @Override
    public void writePayload(DataOutput out) throws IOException {
        ByteArrayDataOutputStream bos = out instanceof ByteArrayDataOutputStream ? (ByteArrayDataOutputStream)out : null;
        int size_pos = bos != null ? bos.position() : -1;
        out.writeInt(this.length);
        PartialOutputStream pos = new PartialOutputStream(out, this.offset, this.length);
        int prev_pos = bos != null ? bos.position() : -1;
        this.original_msg.writeTo(pos);
        int last_pos = bos != null ? bos.position() : -1;
        int written = last_pos - prev_pos;
        if (bos != null && written != this.length) {
            int current_pos = bos.position();
            bos.position(size_pos);
            bos.writeInt(written);
            bos.position(current_pos);
        }
    }

    @Override
    public void readPayload(DataInput in) throws IOException {
        this.length = in.readInt();
        if (this.length > 0) {
            this.array = new byte[this.length];
            in.readFully(this.array);
        }
    }

    @Override
    public String toString() {
        return String.format("%s [off=%d len=%d] (original msg: %s)", this.getClass().getSimpleName(), this.offset, this.length, this.original_msg);
    }

    @Override
    protected <T extends BytesMessage> T createMessage() {
        return (T)new FragmentedMessage();
    }
}

