/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.Objects;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class ClassTypeDetailsImpl
implements ClassTypeDetails {
    private final ClassDetails classDetails;
    private final TypeDetails.Kind kind;

    public ClassTypeDetailsImpl(ClassDetails classDetails, TypeDetails.Kind kind) {
        assert (classDetails != null);
        assert (kind == TypeDetails.Kind.CLASS || kind == TypeDetails.Kind.PRIMITIVE || kind == TypeDetails.Kind.VOID);
        this.classDetails = classDetails;
        this.kind = kind;
    }

    @Override
    public ClassDetails getClassDetails() {
        return this.classDetails;
    }

    @Override
    public String getName() {
        return this.classDetails.getName();
    }

    @Override
    public TypeDetails.Kind getTypeKind() {
        return this.kind;
    }

    @Override
    public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        return this.getClassDetails().resolveTypeVariable(typeVariable);
    }

    public String toString() {
        return "ClassTypeDetails(" + this.classDetails.getName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassTypeDetailsImpl that = (ClassTypeDetailsImpl)o;
        return Objects.equals(this.classDetails, that.classDetails) && this.kind == that.kind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.classDetails, this.kind});
    }
}

