/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CertificateStatusRequestItemV2 {
    protected short statusType;
    protected Object request;

    public CertificateStatusRequestItemV2(short s, Object object) {
        if (!CertificateStatusRequestItemV2.isCorrectType(s, object)) {
            throw new IllegalArgumentException("'request' is not an instance of the correct type");
        }
        this.statusType = s;
        this.request = object;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getRequest() {
        return this.request;
    }

    public OCSPStatusRequest getOCSPStatusRequest() {
        if (!(this.request instanceof OCSPStatusRequest)) {
            throw new IllegalStateException("'request' is not an OCSPStatusRequest");
        }
        return (OCSPStatusRequest)this.request;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.statusType, outputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (this.statusType) {
            case 1: 
            case 2: {
                ((OCSPStatusRequest)this.request).encode(byteArrayOutputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        TlsUtils.writeOpaque16(byArray, outputStream);
    }

    public static CertificateStatusRequestItemV2 parse(InputStream inputStream) throws IOException {
        OCSPStatusRequest oCSPStatusRequest;
        short s = TlsUtils.readUint8(inputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        switch (s) {
            case 1: 
            case 2: {
                oCSPStatusRequest = OCSPStatusRequest.parse(byteArrayInputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return new CertificateStatusRequestItemV2(s, oCSPStatusRequest);
    }

    protected static boolean isCorrectType(short s, Object object) {
        switch (s) {
            case 1: 
            case 2: {
                return object instanceof OCSPStatusRequest;
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }
}

