/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.PrintStream;
import java.util.List;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.LoadObject;
import sun.jvm.hotspot.tools.Tool;

public class PMap
extends Tool {
    public PMap() {
    }

    public PMap(JVMDebugger d) {
        super(d);
    }

    @Override
    public void run() {
        this.run(System.out);
    }

    public void run(PrintStream out) {
        this.run(out, this.getAgent().getDebugger());
    }

    public void run(PrintStream out, Debugger dbg) {
        CDebugger cdbg = dbg.getCDebugger();
        if (cdbg != null) {
            List l = cdbg.getLoadObjectList();
            for (LoadObject lo : l) {
                out.print(lo.getBase() + "\t");
                out.print(lo.getSize() / 1024L + "K\t");
                out.println(lo.getName());
            }
        } else if (this.getDebugeeType() == 2) {
            out.println("remote configuration is not yet implemented");
        } else {
            out.println("not yet implemented (debugger does not support CDebugger)!");
        }
    }

    public static void main(String[] args) throws Exception {
        PMap t = new PMap();
        t.execute(args);
    }
}

