/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.extensions;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u001b\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/extensions/ApplicationExtensionDescriptor;", "T", "", "name", "", "extensionClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;)V", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "registerExtensionPoint", "", "registerExtension", "extension", "disposable", "Lcom/intellij/openapi/Disposable;", "(Ljava/lang/Object;Lcom/intellij/openapi/Disposable;)V", "getInstances", "", "util"})
public class ApplicationExtensionDescriptor<T> {
    @NotNull
    private final Class<T> extensionClass;
    @NotNull
    private final ExtensionPointName<T> extensionPointName;

    public ApplicationExtensionDescriptor(@NotNull String name2, @NotNull Class<T> extensionClass) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        this.extensionClass = extensionClass;
        this.extensionPointName = ExtensionPointName.Companion.create(name2);
    }

    public final void registerExtensionPoint() {
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)ApplicationManager.getApplication().getExtensionArea(), (String)this.extensionPointName.getName(), this.extensionClass);
    }

    public final void registerExtension(@NotNull T extension, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(this.extensionPointName).registerExtension(extension, disposable);
    }

    @NotNull
    public final List<T> getInstances() {
        ExtensionsArea extensionsArea = ApplicationManager.getApplication().getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)extensionsArea, (String)"getExtensionArea(...)");
        ExtensionsArea projectArea = extensionsArea;
        if (!projectArea.hasExtensionPoint(this.extensionPointName.getName())) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = projectArea.getExtensionPoint(this.extensionPointName).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
        return ArraysKt.toList((Object[])objectArray);
    }
}

