/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.projectdata.column;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.ProjectDataColumn;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import utilities.util.FileUtilities;

public class DomainFileSizeProjectDataColumn
extends ProjectDataColumn<Long> {
    private GColumnRenderer<Long> renderer = new AbstractGColumnRenderer<Long>(){

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            if (value == null) {
                value = 0L;
                this.setHorizontalAlignment(4);
            }
            label.setText(this.toDisplayString((Long)value));
            label.setToolTipText(Long.toString((Long)value));
            return label;
        }

        private String toDisplayString(Long l) {
            return FileUtilities.formatLength((long)l);
        }

        public String getFilterString(Long l, Settings settings) {
            return this.toDisplayString(l);
        }
    };

    public String getColumnName() {
        return "Size";
    }

    public Long getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
        String sizeString = info.getMetaDataValue("# of Bytes");
        if (sizeString == null) {
            return null;
        }
        try {
            return Long.parseLong(sizeString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getColumnPreferredWidth() {
        return 120;
    }

    public boolean isDefaultColumn() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public GColumnRenderer<Long> getColumnRenderer() {
        return this.renderer;
    }
}

