/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.IBO32DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;

public class EHUnwindModel
extends AbstractCreateDataTypeModel {
    public static final String DATA_TYPE_NAME = "UnwindMapEntry";
    private static String STRUCTURE_NAME = "_s_UnwindMapEntry";
    private static final int TO_STATE_ORDINAL = 0;
    private static final int ACTION_ORDINAL = 1;
    private DataType dataType;

    public EHUnwindModel(Program program, int unwindCount, Address unwindMapAddress, DataValidationOptions validationOptions) {
        super(program, unwindCount, unwindMapAddress, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        int numEntries = this.getCount();
        for (int unwindBlockOrdinal = 0; unwindBlockOrdinal < numEntries; ++unwindBlockOrdinal) {
            Address actionAddress = this.getActionAddress(unwindBlockOrdinal);
            if (actionAddress == null || EHDataTypeUtilities.isValidForFunction(program, actionAddress)) continue;
            throw new InvalidDataTypeException(this.getName() + " data type at " + String.valueOf(this.getAddress()) + " doesn't refer to a valid location for an action.");
        }
    }

    public static DataType getDataType(Program program) {
        IBO32DataType compDt;
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean isRelative = EHUnwindModel.isRelative(program);
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        DataType ehStateDt = MSDataTypeUtils.getEHStateDataType((Program)program);
        if (ehStateDt == null) {
            ehStateDt = new IntegerDataType((DataTypeManager)dataTypeManager);
        }
        struct.add(ehStateDt, "toState", null);
        if (isRelative) {
            compDt = new IBO32DataType((DataTypeManager)dataTypeManager);
        } else {
            FunctionDefinitionDataType functionDefDt = new FunctionDefinitionDataType(new CategoryPath("/ehdata.h/functions"), "action", (DataTypeManager)dataTypeManager);
            functionDefDt.setReturnType((DataType)new VoidDataType((DataTypeManager)dataTypeManager));
            compDt = new PointerDataType((DataType)functionDefDt, (DataTypeManager)dataTypeManager);
        }
        struct.add((DataType)compDt, "action", null);
        TypedefDataType typedefDt = new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, (DataTypeManager)dataTypeManager);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)typedefDt);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = EHUnwindModel.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    public int getToState(int unwindOrdinal) throws InvalidDataTypeException {
        this.checkValidity(unwindOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(unwindOrdinal, dt);
        return EHDataTypeUtilities.getEHStateValue(dt, 0, specificMemBuffer);
    }

    public Address getActionAddress(int unwindOrdinal) throws InvalidDataTypeException {
        this.checkValidity(unwindOrdinal);
        DataType unwindDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(unwindOrdinal, unwindDt);
        Address refAddress = EHDataTypeUtilities.getAddress(unwindDt, 1, specificMemBuffer);
        return this.getAdjustedAddress(refAddress, 0);
    }

    public Address getComponentAddressOfActionAddress(int unwindOrdinal) throws InvalidDataTypeException {
        this.checkValidity(unwindOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(unwindOrdinal, dt);
        return EHDataTypeUtilities.getComponentAddress(dt, 1, specificMemBuffer);
    }
}

