/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDependencyGraph<T> {
    protected Map<T, DependencyNode> nodeMap = this.createNodeMap();
    protected Set<T> unvisitedIndependentSet = this.createNodeSet();
    private int visitedButNotDeletedCount = 0;

    public Map<T, DependencyNode> getNodeMap() {
        return this.nodeMap;
    }

    protected abstract Map<T, DependencyNode> createNodeMap();

    protected abstract Set<T> createNodeSet();

    protected abstract Set<DependencyNode> createDependencyNodeSet();

    public abstract AbstractDependencyGraph<T> copy();

    public synchronized void addValue(T value) {
        this.getOrCreateDependencyNode(value);
    }

    public synchronized int size() {
        return this.nodeMap.size();
    }

    public synchronized boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    public synchronized boolean contains(T value) {
        return this.nodeMap.containsKey(value);
    }

    public synchronized Set<T> getValues() {
        return new HashSet<T>(this.nodeMap.keySet());
    }

    public abstract Set<T> getNodeMapValues();

    private DependencyNode getOrCreateDependencyNode(T value) {
        DependencyNode dependencyNode = this.nodeMap.get(value);
        if (dependencyNode == null) {
            dependencyNode = new DependencyNode(value);
            this.nodeMap.put(value, dependencyNode);
            this.unvisitedIndependentSet.add(value);
        }
        return dependencyNode;
    }

    public synchronized void addDependency(T value1, T value2) {
        DependencyNode valueNode1 = this.getOrCreateDependencyNode(value1);
        DependencyNode valueNode2 = this.getOrCreateDependencyNode(value2);
        valueNode2.addNodeThatDependsOnMe(valueNode1);
    }

    public synchronized boolean hasUnVisitedIndependentValues() {
        if (!this.unvisitedIndependentSet.isEmpty()) {
            return true;
        }
        this.checkCycleState();
        return false;
    }

    public synchronized T pop() {
        this.checkCycleState();
        if (this.unvisitedIndependentSet.isEmpty()) {
            return null;
        }
        T value = this.unvisitedIndependentSet.iterator().next();
        this.unvisitedIndependentSet.remove(value);
        this.remove(value);
        return value;
    }

    private void checkCycleState() {
        if (!this.isEmpty() && this.unvisitedIndependentSet.isEmpty() && this.visitedButNotDeletedCount == 0) {
            throw new IllegalStateException("Cycle detected!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasCycles() {
        try {
            Set<T> visited = this.createNodeSet();
            while (!this.unvisitedIndependentSet.isEmpty()) {
                Set<T> values = this.getUnvisitedIndependentValues();
                visited.addAll(values);
                for (Object k : values) {
                    DependencyNode node = this.nodeMap.get(k);
                    node.releaseDependencies();
                }
            }
            if (visited.size() != this.nodeMap.size()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.reset();
        }
        return false;
    }

    private void reset() {
        this.visitedButNotDeletedCount = 0;
        for (DependencyNode node : this.nodeMap.values()) {
            node.numberOfNodesThatIDependOn = 0;
        }
        for (DependencyNode node : this.nodeMap.values()) {
            if (node.setOfNodesThatDependOnMe == null) continue;
            for (DependencyNode child : node.setOfNodesThatDependOnMe) {
                this.unvisitedIndependentSet.remove(child.value);
                ++child.numberOfNodesThatIDependOn;
            }
        }
        this.unvisitedIndependentSet = this.getAllIndependentValues();
    }

    public synchronized Set<T> getUnvisitedIndependentValues() {
        this.checkCycleState();
        this.visitedButNotDeletedCount += this.unvisitedIndependentSet.size();
        Set<T> returnCollection = this.unvisitedIndependentSet;
        this.unvisitedIndependentSet = this.createNodeSet();
        return returnCollection;
    }

    public synchronized Set<T> getAllIndependentValues() {
        Set<T> set = this.createNodeSet();
        for (DependencyNode node : this.nodeMap.values()) {
            if (node.numberOfNodesThatIDependOn != 0) continue;
            set.add(node.value);
        }
        return set;
    }

    public synchronized void remove(T value) {
        DependencyNode node = this.nodeMap.remove(value);
        if (node != null) {
            node.releaseDependencies();
            if (this.unvisitedIndependentSet.remove(value)) {
                --this.visitedButNotDeletedCount;
            }
        }
    }

    public synchronized Set<T> getDependentValues(T value) {
        Set<T> set = this.createNodeSet();
        DependencyNode node = this.nodeMap.get(value);
        if (node != null && node.setOfNodesThatDependOnMe != null) {
            for (DependencyNode child : node.setOfNodesThatDependOnMe) {
                set.add(child.value);
            }
        }
        return set;
    }

    protected class DependencyNode {
        private final T value;
        private Set<DependencyNode> setOfNodesThatDependOnMe;
        private int numberOfNodesThatIDependOn = 0;

        DependencyNode(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public Set<DependencyNode> getSetOfNodesThatDependOnMe() {
            return this.setOfNodesThatDependOnMe;
        }

        public int getNumberOfNodesThatIDependOn() {
            return this.numberOfNodesThatIDependOn;
        }

        public void releaseDependencies() {
            if (this.setOfNodesThatDependOnMe == null) {
                return;
            }
            for (DependencyNode node : this.setOfNodesThatDependOnMe) {
                if (--node.numberOfNodesThatIDependOn != 0) continue;
                AbstractDependencyGraph.this.unvisitedIndependentSet.add(node.value);
            }
        }

        public void addNodeThatDependsOnMe(DependencyNode node) {
            if (this.setOfNodesThatDependOnMe == null) {
                this.setOfNodesThatDependOnMe = AbstractDependencyGraph.this.createDependencyNodeSet();
            }
            if (this.setOfNodesThatDependOnMe.add(node)) {
                ++node.numberOfNodesThatIDependOn;
                AbstractDependencyGraph.this.unvisitedIndependentSet.remove(node.value);
            }
        }

        public String toString() {
            return this.value == null ? "" : this.value.toString();
        }
    }
}

