/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.DataConverter;
import java.math.BigInteger;
import java.util.Objects;

public class LittleEndianDataConverter
implements DataConverter {
    public static final LittleEndianDataConverter INSTANCE = new LittleEndianDataConverter();
    private static final long serialVersionUID = 1L;

    @Override
    public short getShort(byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, 2, b.length);
        return (short)((b[offset + 1] & 0xFF) << 8 | b[offset] & 0xFF);
    }

    @Override
    public int getInt(byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, 4, b.length);
        int v = b[offset + 3];
        for (int i = 2; i >= 0; --i) {
            v = v << 8 | b[offset + i] & 0xFF;
        }
        return v;
    }

    @Override
    public long getLong(byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, 8, b.length);
        long v = b[offset + 7];
        for (int i = 6; i >= 0; --i) {
            v = v << 8 | (long)(b[offset + i] & 0xFF);
        }
        return v;
    }

    @Override
    public long getValue(byte[] b, int offset, int size) {
        Objects.checkFromIndexSize(offset, size, b.length);
        Objects.checkIndex(size, 9);
        long val = 0L;
        for (int i = size - 1; i >= 0; --i) {
            val = val << 8 | (long)(b[offset + i] & 0xFF);
        }
        return val;
    }

    @Override
    public BigInteger getBigInteger(byte[] b, int offset, int size, boolean signed) {
        Objects.checkFromIndexSize(offset, size, b.length);
        int msbIndex = 0;
        if (!signed) {
            ++size;
            msbIndex = 1;
        }
        int bIndex = 0;
        byte[] bytes = new byte[size];
        for (int i = size - 1; i >= msbIndex; --i) {
            bytes[i] = b[offset + bIndex++];
        }
        return new BigInteger(bytes);
    }

    @Override
    public void putShort(byte[] b, int offset, short value) {
        Objects.checkFromIndexSize(offset, 2, b.length);
        b[offset + 1] = (byte)(value >> 8);
        b[offset] = (byte)(value & 0xFF);
    }

    @Override
    public void putInt(byte[] b, int offset, int value) {
        Objects.checkFromIndexSize(offset, 4, b.length);
        b[offset] = (byte)value;
        for (int i = 1; i < 4; ++i) {
            b[offset + i] = (byte)(value >>= 8);
        }
    }

    @Override
    public void putValue(long value, int size, byte[] b, int offset) {
        Objects.checkFromIndexSize(offset, size, b.length);
        Objects.checkIndex(size, 9);
        for (int i = 0; i < size; ++i) {
            b[offset + i] = (byte)value;
            value >>= 8;
        }
    }

    @Override
    public void putBigInteger(byte[] b, int offset, int size, BigInteger value) {
        Objects.checkFromIndexSize(offset, size, b.length);
        int fillIndex = offset + size - 1;
        byte[] valBytes = value.toByteArray();
        if (valBytes.length >= size) {
            srcIndex = valBytes.length - size;
        } else {
            srcIndex = 0;
            int signbits = value.signum() < 0 ? -1 : 0;
            for (int i = valBytes.length; i < size; ++i) {
                b[fillIndex--] = signbits;
            }
        }
        for (int i = srcIndex; i < valBytes.length; ++i) {
            b[fillIndex--] = valBytes[i];
        }
    }
}

