/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.pdb.classtype.ClassTypeManager;
import ghidra.app.util.pdb.classtype.VirtualBaseTable;
import ghidra.app.util.pdb.classtype.VirtualFunctionTable;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.PointerDataType;
import java.util.HashMap;
import java.util.Map;

public class VxtManager {
    protected ClassTypeManager ctm;
    protected Map<Address, VirtualBaseTable> vbtByAddress;
    protected Map<Address, VirtualFunctionTable> vftByAddress;

    public VxtManager(ClassTypeManager ctm) {
        this.ctm = ctm;
        this.vbtByAddress = new HashMap<Address, VirtualBaseTable>();
        this.vftByAddress = new HashMap<Address, VirtualFunctionTable>();
    }

    public PointerDataType getDefaultVbtPtr() {
        return this.ctm.getDefaultVbtPtr();
    }

    public PointerDataType getDefaultVftPtr() {
        return this.ctm.getDefaultVftPtr();
    }

    public VirtualBaseTable getVbt(Address address) {
        return this.vbtByAddress.get(address);
    }

    public VirtualFunctionTable getVft(Address address) {
        return this.vftByAddress.get(address);
    }
}

