/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import generic.Span;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public sealed interface Lifespan
extends Span<Long, Lifespan>,
Iterable<Long> {
    public static final Domain DOMAIN = Domain.INSTANCE;
    public static final Empty EMPTY = Empty.INSTANCE;
    public static final Impl ALL = new Impl(Long.MIN_VALUE, Long.MAX_VALUE);

    public static Lifespan span(long minSnap, long maxSnap) {
        return DOMAIN.closed(minSnap, maxSnap);
    }

    public static Lifespan at(long snap) {
        return DOMAIN.value(snap);
    }

    public static Lifespan since(long snap) {
        return new Impl(0L, snap);
    }

    public static Lifespan nowOn(long snap) {
        return DOMAIN.atLeast(snap);
    }

    public static Lifespan nowOnMaybeScratch(long snap) {
        if (Lifespan.isScratch(snap)) {
            return new Impl(snap, -1L);
        }
        return new Impl(snap, Long.MAX_VALUE);
    }

    public static boolean isScratch(long snap) {
        return snap < 0L;
    }

    public static Lifespan toNow(long snap) {
        return DOMAIN.atMost(snap);
    }

    public static Lifespan before(long snap) {
        if (snap == DOMAIN.lmin()) {
            return EMPTY;
        }
        return DOMAIN.atMost(DOMAIN.dec(snap));
    }

    default public Domain domain() {
        return DOMAIN;
    }

    public long lmin();

    public long lmax();

    public boolean contains(long var1);

    default public Lifespan withMin(long min) {
        return DOMAIN.closed(min, this.lmax());
    }

    default public Lifespan withMax(long max) {
        return DOMAIN.closed(this.lmin(), max);
    }

    public static enum Domain implements Span.Domain<Long, Lifespan>
    {
        INSTANCE;


        public Lifespan closed(Long min, Long max) {
            return this.closed((long)min, (long)max);
        }

        public Lifespan closed(long min, long max) {
            if (max < min) {
                throw new IllegalArgumentException("max < min: min=" + min + ",max=" + max);
            }
            return new Impl(min, max);
        }

        public Lifespan newSpan(Long min, Long max) {
            return new Impl(min, max);
        }

        public Lifespan value(long n) {
            return new Impl(n, n);
        }

        public Lifespan atMost(Long max) {
            return this.atMost((long)max);
        }

        public Lifespan atMost(long max) {
            return new Impl(Long.MIN_VALUE, max);
        }

        public Lifespan atLeast(Long min) {
            return this.atLeast((long)min);
        }

        public Lifespan atLeast(long min) {
            return new Impl(min, Long.MAX_VALUE);
        }

        public Lifespan all() {
            return ALL;
        }

        public Lifespan empty() {
            return EMPTY;
        }

        public int compare(Long n1, Long n2) {
            return this.compare((long)n1, (long)n2);
        }

        public int compare(long n1, long n2) {
            return Long.compare(n1, n2);
        }

        public Long min() {
            return this.lmin();
        }

        public long lmin() {
            return Long.MIN_VALUE;
        }

        public Long max() {
            return this.lmax();
        }

        public long lmax() {
            return Long.MAX_VALUE;
        }

        public Long inc(Long n) {
            return this.inc((long)n);
        }

        public long inc(long n) {
            return n + 1L;
        }

        public Long dec(Long n) {
            return this.dec((long)n);
        }

        public long dec(long n) {
            return n - 1L;
        }

        public long min(long n1, long n2) {
            return Long.min(n1, n2);
        }

        public long max(long n1, long n2) {
            return Long.max(n1, n2);
        }

        public Lifespan intersect(Lifespan s1, Lifespan s2) {
            if (!this.intersects(s1, s2)) {
                return this.empty();
            }
            return new Impl(this.max(s1.lmin(), s2.lmin()), this.min(s1.lmax(), s2.lmax()));
        }

        public boolean intersects(Lifespan s1, Lifespan s2) {
            if (s1.isEmpty() || s2.isEmpty()) {
                return false;
            }
            return s1.lmax() >= s2.lmin() && s2.lmax() >= s1.lmin();
        }

        public boolean encloses(Lifespan s1, Lifespan s2) {
            return s1.lmin() <= s2.lmin() && s2.lmax() <= s1.lmax();
        }

        public Lifespan bound(Lifespan s1, Lifespan s2) {
            if (s1.isEmpty()) {
                return s2;
            }
            if (s2.isEmpty()) {
                return s1;
            }
            return new Impl(this.min(s1.lmin(), s2.lmin()), this.max(s1.lmax(), s2.lmax()));
        }
    }

    public record Impl(long lmin, long lmax) implements Lifespan
    {
        @Override
        public String toString() {
            return this.toString(arg_0 -> ((Domain)DOMAIN).toString(arg_0));
        }

        @Override
        public boolean contains(long n) {
            return this.lmin <= n && n <= this.lmax;
        }

        public boolean contains(Long n) {
            return this.lmin <= n && n <= this.lmax;
        }

        public Long min() {
            return this.lmin;
        }

        public Long max() {
            return this.lmax;
        }

        public boolean minIsFinite() {
            return this.lmin != this.domain().lmin();
        }

        public boolean maxIsFinite() {
            return this.lmax != this.domain().lmax();
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                long val;
                {
                    this.val = lmin;
                }

                @Override
                public boolean hasNext() {
                    return this.val <= lmax;
                }

                @Override
                public Long next() {
                    long next = this.val++;
                    return next;
                }
            };
        }
    }

    public static final class Empty
    implements Lifespan,
    Span.Empty<Long, Lifespan> {
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        public String toString() {
            return this.toString(arg_0 -> ((Domain)DOMAIN).toString(arg_0));
        }

        @Override
        public long lmin() {
            throw new NoSuchElementException();
        }

        public Long min() {
            throw new NoSuchElementException();
        }

        @Override
        public long lmax() {
            throw new NoSuchElementException();
        }

        public Long max() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean contains(long n) {
            return false;
        }

        public boolean contains(Long n) {
            return false;
        }

        @Override
        public Iterator<Long> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class DefaultLifeSet
    extends Span.DefaultSpanSet<Long, Lifespan>
    implements MutableLifeSet {
        public static DefaultLifeSet copyOf(LifeSet set) {
            DefaultLifeSet copy = new DefaultLifeSet();
            copy.addAll(set);
            return copy;
        }

        public DefaultLifeSet() {
            super((Span.Domain)DOMAIN);
        }
    }

    public static interface MutableLifeSet
    extends LifeSet,
    Span.MutableSpanSet<Long, Lifespan> {
    }

    public static interface LifeSet
    extends Span.SpanSet<Long, Lifespan> {
    }
}

