/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowBlockAnalyzer;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitOpUpwardVisitor;
import ghidra.pcode.emu.jit.analysis.JitVarScopeModel;
import ghidra.pcode.emu.jit.op.JitCallOtherOpIf;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.op.JitPhiOp;
import ghidra.pcode.emu.jit.var.JitMissingVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class JitOpUseModel {
    private final JitAnalysisContext context;
    private final JitControlFlowModel cfm;
    private final JitDataFlowModel dfm;
    private final JitVarScopeModel vsm;
    private final Set<JitOp> used = new HashSet<JitOp>();

    public JitOpUseModel(JitAnalysisContext context, JitControlFlowModel cfm, JitDataFlowModel dfm, JitVarScopeModel vsm) {
        this.context = context;
        this.cfm = cfm;
        this.dfm = dfm;
        this.vsm = vsm;
        if (context.getConfiguration().removeUnusedOperations()) {
            this.analyze();
        }
    }

    private Set<Varnode> getCallOtherRetireVarnodes(JitControlFlowModel.JitBlock block, JitCallOtherOpIf op) {
        if (op.userop().isFunctional()) {
            return Set.of();
        }
        return this.vsm.getLiveVars(block);
    }

    private Set<Varnode> getCouldRetireVarnodes(JitControlFlowModel.JitBlock block) {
        if (!block.branchesOut().isEmpty()) {
            return this.vsm.getLiveVars(block);
        }
        if (block.flowsFrom().isEmpty()) {
            throw new AssertionError();
        }
        HashSet<Varnode> aliveAfterAnyFlow = new HashSet<Varnode>(this.vsm.getLiveVars(block.flowsFrom().values().iterator().next().to()));
        for (JitControlFlowModel.BlockFlow flow : block.flowsFrom().values()) {
            aliveAfterAnyFlow.retainAll(this.vsm.getLiveVars(flow.to()));
        }
        HashSet<Varnode> result = new HashSet<Varnode>(this.vsm.getLiveVars(block));
        result.removeAll(aliveAfterAnyFlow);
        return result;
    }

    private void analyze() {
        Set<JitPhiOp> phisBefore = Set.copyOf(this.dfm.phiNodes());
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            for (PcodeOp op : block.getCode()) {
                JitOp jitOp = this.dfm.getJitOp(op);
                if (!(jitOp instanceof JitCallOtherOpIf)) continue;
                JitCallOtherOpIf callother = (JitCallOtherOpIf)jitOp;
                for (Varnode vn : this.getCallOtherRetireVarnodes(block, callother)) {
                    callother.dfState().getVar(vn);
                }
            }
            for (Varnode vn : this.getCouldRetireVarnodes(block)) {
                JitDataFlowBlockAnalyzer analyzer = this.dfm.getAnalyzer(block);
                analyzer.getVar(vn);
            }
        }
        LinkedHashSet<JitPhiOp> extraPhis = new LinkedHashSet<JitPhiOp>(this.dfm.phiNodes());
        extraPhis.removeAll(phisBefore);
        this.dfm.analyzeInterblock(extraPhis);
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            OpUseCollector collector = new OpUseCollector(block);
            for (PcodeOp op : block.getCode()) {
                JitOp jitOp = this.dfm.getJitOp(op);
                if (jitOp instanceof JitCallOtherOpIf) {
                    JitCallOtherOpIf callotherOp = (JitCallOtherOpIf)jitOp;
                    for (Varnode vn : this.getCallOtherRetireVarnodes(block, callotherOp)) {
                        collector.visitCallOtherRetireable(vn, callotherOp);
                    }
                }
                if (jitOp.canBeRemoved()) continue;
                collector.visitOp(jitOp);
            }
            for (Varnode vn : this.getCouldRetireVarnodes(block)) {
                collector.visitRetireable(vn);
            }
        }
    }

    public boolean isUsed(JitOp op) {
        if (this.context.getConfiguration().removeUnusedOperations()) {
            return this.used.contains(op);
        }
        return true;
    }

    public void dumpResult() {
        System.err.println("STAGE: OpUse");
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            JitDataFlowBlockAnalyzer analyzer = this.dfm.getAnalyzer(block);
            System.err.println("  Block: " + String.valueOf(block));
            for (Varnode vn : this.getCouldRetireVarnodes(block)) {
                for (JitVal val : analyzer.getOutput(vn)) {
                    System.err.println("    Could retire: " + String.valueOf(val));
                }
            }
            for (PcodeOp op : block.getCode()) {
                JitOp jitOp = this.dfm.getJitOp(op);
                if (this.isUsed(jitOp)) continue;
                System.err.println("    Removed: %s: %s".formatted(op.getSeqnum(), jitOp));
            }
        }
    }

    class OpUseCollector
    implements JitOpUpwardVisitor {
        final JitControlFlowModel.JitBlock block;
        final JitDataFlowBlockAnalyzer analyzer;

        public OpUseCollector(JitControlFlowModel.JitBlock block) {
            this.block = block;
            this.analyzer = JitOpUseModel.this.dfm.getAnalyzer(block);
        }

        @Override
        public void visitOp(JitOp op) {
            if (!JitOpUseModel.this.used.add(op)) {
                return;
            }
            JitOpUpwardVisitor.super.visitOp(op);
        }

        @Override
        public void visitMissingVar(JitMissingVar missingVar) {
            throw new AssertionError((Object)("missing: " + String.valueOf(missingVar)));
        }

        void visitRetireable(Varnode vn) {
            for (JitVal val : this.analyzer.getOutput(vn)) {
                this.visitVal(val);
            }
        }

        void visitCallOtherRetireable(Varnode vn, JitCallOtherOpIf callother) {
            for (JitVal val : callother.dfState().getDefinitions(vn)) {
                this.visitVal(val);
            }
        }
    }
}

