/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.transform.MutableTransformer;

public class LayoutScalingControl
implements ScalingControl {
    protected double minScale;
    protected double maxScale;

    public static Builder builder() {
        return new Builder();
    }

    LayoutScalingControl(Builder builder) {
        this.minScale = builder.minScale;
        this.maxScale = builder.maxScale;
    }

    public LayoutScalingControl() {
        this(LayoutScalingControl.builder());
    }

    @Override
    public void scale(VisualizationServer<?, ?> vv, double horizontalAmount, double verticalAmount, Point2D from) {
        Point2D ivtfrom = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, from);
        MutableTransformer modelTransformer = vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        double scaleX = modelTransformer.getScaleX();
        double scaleY = modelTransformer.getScaleY();
        if (scaleX > this.maxScale && horizontalAmount > 1.0) {
            return;
        }
        if (scaleX < this.minScale && horizontalAmount < 1.0) {
            return;
        }
        if (scaleY > this.maxScale && verticalAmount > 1.0) {
            return;
        }
        if (scaleY < this.minScale && verticalAmount < 1.0) {
            return;
        }
        modelTransformer.scale(horizontalAmount, verticalAmount, ivtfrom);
        vv.repaint();
    }

    public static class Builder {
        double minScale = Double.parseDouble(System.getProperty("jungrapht.minScale", "0.2"));
        double maxScale = Double.parseDouble(System.getProperty("jungrapht.maxScale", "5.0"));

        public Builder minScale(double minScale) {
            this.minScale = minScale;
            return this;
        }

        public Builder maxScale(double maxScale) {
            this.maxScale = maxScale;
            return this;
        }

        public ScalingControl build() {
            return new LayoutScalingControl(this);
        }
    }
}

