/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsComponentLoader;
import org.jetbrains.jps.model.serialization.JpsMacroExpander;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactSerializer;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.TimingLog;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationSerializer;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Internal
public final class JpsProjectConfigurationLoading {
    private JpsProjectConfigurationLoading() {
    }

    public static void setupSerializationExtension(@NotNull JpsProject project, @NotNull Path baseDir) {
        if (project == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(1);
        }
        project.getContainer().setChild(JpsProjectSerializationDataExtensionImpl.ROLE, new JpsProjectSerializationDataExtensionImpl(baseDir));
    }

    public static JpsMacroExpander createProjectMacroExpander(Map<String, String> pathVariables, @NotNull Path baseDir) {
        if (baseDir == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(2);
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        expander.addFileHierarchyReplacements("PROJECT_DIR", baseDir.toFile());
        return expander;
    }

    @Nullable
    public static Path getExternalConfigurationDirectoryFromSystemProperty() {
        String externalProjectConfigDir = System.getProperty("external.project.config");
        return externalProjectConfigDir != null && !externalProjectConfigDir.isBlank() ? Path.of(externalProjectConfigDir, new String[0]) : null;
    }

    @NotNull
    public static String getDirectoryBaseProjectName(@NotNull Path basePath, @NotNull Path storeDir) {
        String name;
        if (basePath == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(3);
        }
        if (storeDir == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(4);
        }
        String string = (name = JpsPathUtil.readProjectName(storeDir)) != null ? name : NioFiles.getFileName((Path)basePath);
        if (string == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void loadRunConfigurationsFromDirectory(@NotNull JpsProject project, @NotNull JpsComponentLoader componentLoader, @NotNull Path dir, @NotNull Path workspaceFile) {
        if (project == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(6);
        }
        if (componentLoader == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(8);
        }
        if (workspaceFile == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(9);
        }
        if (JpsProjectConfigurationLoading.hasRunConfigurationSerializers()) {
            Runnable runConfTimingLog = TimingLog.startActivity("loading run configurations");
            for (Path configurationFile : JpsProjectConfigurationLoading.listXmlFiles(dir.resolve("runConfigurations"))) {
                JpsRunConfigurationSerializer.loadRunConfigurations(project, componentLoader.loadRootElement(configurationFile));
            }
            JpsRunConfigurationSerializer.loadRunConfigurations(project, componentLoader.loadComponent(workspaceFile, "RunManager"));
            runConfTimingLog.run();
        }
    }

    public static void loadArtifactsFromDirectory(@NotNull JpsProject project, @NotNull JpsComponentLoader componentLoader, @NotNull Path dir, @Nullable Path externalConfigDir) {
        if (project == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(10);
        }
        if (componentLoader == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(12);
        }
        Runnable artifactsTimingLog = TimingLog.startActivity("loading artifacts");
        for (Path artifactFile : JpsProjectConfigurationLoading.listXmlFiles(dir.resolve("artifacts"))) {
            @Nullable Element artifactManagerComponent = componentLoader.loadRootElement(artifactFile);
            JpsArtifactSerializer.loadArtifacts(project, artifactManagerComponent);
        }
        if (externalConfigDir != null) {
            @Nullable Element artifactManagerComponent = componentLoader.loadRootElement(externalConfigDir.resolve("artifacts.xml"));
            JpsArtifactSerializer.loadArtifacts(project, artifactManagerComponent);
        }
        artifactsTimingLog.run();
    }

    private static boolean hasRunConfigurationSerializers() {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            if (extension.getRunConfigurationPropertiesSerializers().isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    static @Unmodifiable @NotNull List<Path> listXmlFiles(@NotNull Path dir) {
        List list;
        DirectoryStream<Path> stream;
        block11: {
            if (dir == null) {
                JpsProjectConfigurationLoading.$$$reportNull$$$0(13);
            }
            stream = Files.newDirectoryStream(dir, it -> it.getFileName().toString().endsWith(".xml") && Files.isRegularFile(it, new LinkOption[0]));
            list = ContainerUtil.collect(stream.iterator());
            if (stream == null) break block11;
            stream.close();
        }
        List list2 = list;
        if (list2 == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(14);
        }
        return list2;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    List<Path> list3 = Collections.emptyList();
                    if (list3 == null) {
                        JpsProjectConfigurationLoading.$$$reportNull$$$0(15);
                    }
                    return list3;
                }
            }
        }
    }

    public static void loadRunConfigurationsFromIpr(@NotNull JpsProject project, @Nullable Element iprRoot, @Nullable Element iwsRoot) {
        if (project == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(16);
        }
        if (JpsProjectConfigurationLoading.hasRunConfigurationSerializers()) {
            JpsRunConfigurationSerializer.loadRunConfigurations(project, JDomSerializationUtil.findComponent(iprRoot, "ProjectRunConfigurationManager"));
            JpsRunConfigurationSerializer.loadRunConfigurations(project, JDomSerializationUtil.findComponent(iwsRoot, "RunManager"));
        }
    }

    public static void loadArtifactsFromIpr(@NotNull JpsProject project, @Nullable Element iprRoot) {
        if (project == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(17);
        }
        @Nullable Element artifactManagerComponent = JDomSerializationUtil.findComponent(iprRoot, "ArtifactManager");
        JpsArtifactSerializer.loadArtifacts(project, artifactManagerComponent);
    }

    public static void loadProjectExtensionsFromIpr(@NotNull JpsProject project, @Nullable Element iprRoot, @Nullable Element iwsRoot) {
        if (project == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(18);
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsProjectExtensionSerializer jpsProjectExtensionSerializer : extension.getProjectExtensionSerializers()) {
                Element rootTag = "workspace.xml".equals(jpsProjectExtensionSerializer.getConfigFileName()) ? iwsRoot : iprRoot;
                Element component = JDomSerializationUtil.findComponent(rootTag, jpsProjectExtensionSerializer.getComponentName());
                if (component != null) {
                    jpsProjectExtensionSerializer.loadExtension(project, component);
                    continue;
                }
                jpsProjectExtensionSerializer.loadExtensionWithDefaultSettings(project);
            }
        }
    }

    @Nullable
    public static Pair<String, String> readProjectSdkTypeAndName(@Nullable Element rootElement) {
        Pair sdkTypeIdAndName = null;
        Element rootManagerElement = JDomSerializationUtil.findComponent(rootElement, "ProjectRootManager");
        if (rootManagerElement != null) {
            String sdkName = rootManagerElement.getAttributeValue("project-jdk-name");
            String sdkTypeId = rootManagerElement.getAttributeValue("project-jdk-type");
            if (sdkName != null) {
                sdkTypeIdAndName = new Pair((Object)Objects.requireNonNullElse(sdkTypeId, "JavaSDK"), (Object)sdkName);
            }
        }
        return sdkTypeIdAndName;
    }

    public static JpsMacroExpander createModuleMacroExpander(Map<String, String> pathVariables, @NotNull Path moduleFile) {
        if (moduleFile == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(19);
        }
        JpsMacroExpander expander = new JpsMacroExpander(pathVariables);
        String moduleDirPath = PathMacroUtil.getModuleDir(moduleFile.toAbsolutePath().toString());
        if (moduleDirPath != null) {
            expander.addFileHierarchyReplacements("MODULE_DIR", new File(FileUtilRt.toSystemDependentName((String)moduleDirPath)));
        }
        return expander;
    }

    @NotNull
    public static Set<String> readNamesOfUnloadedModules(@NotNull Path workspaceFile, @NotNull JpsComponentLoader componentLoader) {
        if (workspaceFile == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(20);
        }
        if (componentLoader == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(21);
        }
        HashSet<String> unloadedModules = new HashSet<String>();
        if (workspaceFile.toFile().exists()) {
            Element unloadedModulesList = componentLoader.loadComponent(workspaceFile, "UnloadedModulesList");
            for (Element element : JDOMUtil.getChildren((Element)unloadedModulesList, (String)"module")) {
                unloadedModules.add(element.getAttributeValue("name"));
            }
        }
        HashSet<String> hashSet = unloadedModules;
        if (hashSet == null) {
            JpsProjectConfigurationLoading.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storeDir";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsProjectConfigurationLoading";
                break;
            }
            case 7: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentLoader";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsProjectConfigurationLoading";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryBaseProjectName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "listXmlFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readNamesOfUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupSerializationExtension";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProjectMacroExpander";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryBaseProjectName";
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 22: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadRunConfigurationsFromDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadArtifactsFromDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "listXmlFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadRunConfigurationsFromIpr";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadArtifactsFromIpr";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadProjectExtensionsFromIpr";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createModuleMacroExpander";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readNamesOfUnloadedModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 14: 
            case 15: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

