/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.actions.ViewStructureAction;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ShowFileStructurePopupCommand
extends AbstractCommand
implements Disposable {
    public static final String PREFIX = "%showFileStructureDialog";
    public static final String SPAN_NAME = "FileStructurePopup";

    public ShowFileStructurePopupCommand(@NotNull String text, int line) {
        if (text == null) {
            ShowFileStructurePopupCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ShowFileStructurePopupCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
            @NotNull Project project = context.getProject();
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            if (fileEditor == null) {
                Collection editors = FileEditorManager.getInstance((Project)project).getSelectedEditorWithRemotes();
                if (editors.size() > 1) {
                    actionCallback.reject("Too many selected editors");
                    return;
                }
                fileEditor = (FileEditor)editors.iterator().next();
            }
            if (fileEditor != null) {
                Span span = PerformanceTestSpan.TRACER.spanBuilder(SPAN_NAME).startSpan();
                try (Scope ignored = span.makeCurrent();){
                    FileStructurePopup popup = ViewStructureAction.createPopup((Project)project, (FileEditor)fileEditor);
                    if (popup != null) {
                        Span spanShow = PerformanceTestSpan.TRACER.spanBuilder("FileStructurePopup#Show").startSpan();
                        Span spanFill = PerformanceTestSpan.TRACER.spanBuilder("FileStructurePopup#Fill").startSpan();
                        popup.showWithResult().onProcessed(path -> {
                            actionCallback.setDone();
                            spanFill.end();
                            span.end();
                        });
                        spanShow.end();
                    }
                    span.setStatus(StatusCode.ERROR, "File structure popup is null");
                    actionCallback.reject("File structure popup is null");
                }
            } else {
                actionCallback.reject("File editor is null");
            }
        }));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            ShowFileStructurePopupCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/ShowFileStructurePopupCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/ShowFileStructurePopupCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

