/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Nullable;

public final class CollectionUtil {
    @Nullable
    public static PsiClassType createSimilarCollection(@Nullable PsiType collection, Project project, PsiType ... itemType) {
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.SortedSet")) {
            return CollectionUtil.createCollection(project, "java.util.SortedSet", itemType);
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.LinkedHashSet")) {
            return CollectionUtil.createCollection(project, "java.util.LinkedHashSet", itemType);
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.Set")) {
            return CollectionUtil.createCollection(project, "java.util.HashSet", itemType);
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.LinkedList")) {
            return CollectionUtil.createCollection(project, "java.util.LinkedList", itemType);
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.Stack")) {
            return CollectionUtil.createCollection(project, "java.util.Stack", itemType);
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.Vector")) {
            return CollectionUtil.createCollection(project, "java.util.Vector", itemType);
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.List")) {
            return CollectionUtil.createCollection(project, "java.util.ArrayList", itemType);
        }
        if (InheritanceUtil.isInheritor((PsiType)collection, (String)"java.util.Queue")) {
            return CollectionUtil.createCollection(project, "java.util.LinkedList", itemType);
        }
        return CollectionUtil.createCollection(project, "java.util.ArrayList", itemType);
    }

    @Nullable
    private static PsiClassType createCollection(Project project, String collectionName, PsiType ... item) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiClass collection = JavaPsiFacade.getInstance((Project)project).findClass(collectionName, GlobalSearchScope.allScope((Project)project));
        if (collection == null) {
            return null;
        }
        PsiTypeParameter[] parameters = collection.getTypeParameters();
        if (parameters.length != 1) {
            return null;
        }
        return factory.createType(collection, item);
    }
}

