/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding.gradle;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialogWithEmail;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.platform.feedback.impl.notification.ThanksForFeedbackNotification;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.net.URI;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleJava.KotlinGradlePluginVersionKt;
import org.jetbrains.kotlin.idea.gradleTooling.KotlinGradlePluginVersion;
import org.jetbrains.kotlin.onboarding.KotlinNewUserTracker;
import org.jetbrains.kotlin.onboarding.gradle.BuildProcessSatisfactionDialogData;
import org.jetbrains.kotlin.onboarding.gradle.BuildProcessSatisfactionSurveyStore;
import org.jetbrains.kotlin.onboarding.gradle.GradleFeedbackBundle;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\f\u0010\u0015\u001a\u00020\n*\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0002H\u0002J\b\u0010$\u001a\u00020\u0006H\u0014J\b\u00100\u001a\u00020'H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020\u0014X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001fR\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001fR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialogWithEmail;", "Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialogData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "myFeedbackJsonVersion", "", "getMyFeedbackJsonVersion", "()I", "distributionUrlRegex", "Lkotlin/text/Regex;", "getGradleWrapperVersion", "Lorg/gradle/util/GradleVersion;", "getGradleVersion", "getKotlinVersions", "", "", "daysSinceDate", "Ljava/time/LocalDate;", "collectData", "mySystemInfoData", "getMySystemInfoData", "()Lorg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialogData;", "mySystemInfoData$delegate", "Lkotlin/Lazy;", "zendeskTicketTitle", "getZendeskTicketTitle", "()Ljava/lang/String;", "zendeskFeedbackType", "getZendeskFeedbackType", "myFeedbackReportId", "getMyFeedbackReportId", "shouldAutoCloseZendeskTicket", "myShowFeedbackSystemInfoDialog", "Lkotlin/Function0;", "", "getMyShowFeedbackSystemInfoDialog", "()Lkotlin/jvm/functions/Function0;", "myTitle", "getMyTitle", "myBlocks", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "showThanksNotification", "kotlin.onboarding.gradle"})
@SourceDebugExtension(value={"SMAP\nBuildProcessSatisfactionDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildProcessSatisfactionDialog.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,172:1\n1617#2,9:173\n1869#2:182\n1870#2:184\n1626#2:185\n1788#2,4:204\n1#3:183\n1#3:196\n1#3:201\n11546#4,9:186\n13472#4:195\n13473#4:197\n11555#4:198\n11554#4:199\n13472#4:200\n13473#4:202\n11555#4:203\n*S KotlinDebug\n*F\n+ 1 BuildProcessSatisfactionDialog.kt\norg/jetbrains/kotlin/onboarding/gradle/BuildProcessSatisfactionDialog\n*L\n63#1:173,9\n63#1:182\n63#1:184\n63#1:185\n82#1:204,4\n63#1:183\n70#1:196\n78#1:201\n70#1:186,9\n70#1:195\n70#1:197\n70#1:198\n78#1:199\n78#1:200\n78#1:202\n78#1:203\n*E\n"})
public final class BuildProcessSatisfactionDialog
extends BlockBasedFeedbackDialogWithEmail<BuildProcessSatisfactionDialogData> {
    @NotNull
    private final Project project;
    private final int myFeedbackJsonVersion;
    @NotNull
    private final Regex distributionUrlRegex;
    @NotNull
    private final Lazy mySystemInfoData$delegate;
    @NotNull
    private final String zendeskTicketTitle;
    @NotNull
    private final String zendeskFeedbackType;
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final Function0<Unit> myShowFeedbackSystemInfoDialog;
    @NotNull
    private final String myTitle;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public BuildProcessSatisfactionDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, forTest);
        this.project = project;
        this.myFeedbackJsonVersion = super.getMyFeedbackJsonVersion() + 1;
        this.distributionUrlRegex = new Regex("://services\\.gradle\\.org/distributions/gradle-([\\w.\\-_]+)-(?:all|bin)\\.zip");
        this.mySystemInfoData$delegate = LazyKt.lazy(() -> BuildProcessSatisfactionDialog.mySystemInfoData_delegate$lambda$4(this));
        this.zendeskTicketTitle = "Kotlin Build Process in-IDE Feedback";
        this.zendeskFeedbackType = "Kotlin Build Process Feedback";
        this.myFeedbackReportId = "kotlin_gradle_build_process_feedback";
        this.myShowFeedbackSystemInfoDialog = () -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14(this);
        this.myTitle = GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.top.title", new Object[0]);
        Object[] objectArray = new FeedbackBlock[]{new TopLabelBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.title", new Object[0])), new DescriptionBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.description", new Object[0])), new RatingBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.rating.label", new Object[0]), "rating"), new TextAreaBlock(GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.improve.label", new Object[0]), "improvements")};
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    protected int getMyFeedbackJsonVersion() {
        return this.myFeedbackJsonVersion;
    }

    private final GradleVersion getGradleWrapperVersion() {
        Object object = GradleUtil.getWrapperConfiguration((String)this.project.getBasePath());
        if (object == null || (object = object.getDistribution()) == null) {
            return null;
        }
        Object wrapperConfiguration = object;
        String string = ((URI)wrapperConfiguration).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        MatchResult matchResult = Regex.find$default((Regex)this.distributionUrlRegex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String versionPart = (String)matchResult2.getGroupValues().get(1);
        return GradleVersion.version((String)versionPart);
    }

    /*
     * WARNING - void declaration
     */
    private final GradleVersion getGradleVersion() {
        void $this$mapNotNullTo$iv$iv;
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleSettings, (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        Collection collection = settings2.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GradleVersion it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            GradleProjectSettings it = (GradleProjectSettings)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (GradleInstallationManager.Companion.guessGradleVersion(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        GradleVersion linkedVersion = (GradleVersion)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        GradleVersion gradleVersion = linkedVersion;
        if (gradleVersion == null) {
            gradleVersion = this.getGradleWrapperVersion();
        }
        return gradleVersion;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getKotlinVersions() {
        void $this$mapNotNullTo$iv$iv;
        Module[] $this$mapNotNull$iv = ProjectUtil.getModules((Project)this.project);
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            KotlinGradlePluginVersion kotlinGradlePluginVersion = KotlinGradlePluginVersionKt.getKotlinGradlePluginVersion((Module)it);
            if ((kotlinGradlePluginVersion != null ? kotlinGradlePluginVersion.getVersionString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final int daysSinceDate(LocalDate $this$daysSinceDate) {
        return (int)ChronoUnit.DAYS.between($this$daysSinceDate, LocalDate.now());
    }

    /*
     * WARNING - void declaration
     */
    private final BuildProcessSatisfactionDialogData collectData() {
        String string;
        Object gradleVersion;
        void $this$mapNotNullTo$iv;
        Module[] moduleArray = ProjectUtil.getModules((Project)this.project);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            Path it$iv;
            void element$iv$iv;
            void element$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl = false;
            void it = element$iv;
            boolean bl2 = false;
            String string2 = ExternalSystemApiUtil.getExternalProjectPath((Module)it);
            if ((string2 != null ? NioPathUtil.toNioPathOrNull((String)string2) : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set allExternalModulePaths = (Set)destination$iv;
        int groovyCount = BuildProcessSatisfactionDialog.collectData$countExistingFiles(allExternalModulePaths, "build.gradle");
        int ktsCount = BuildProcessSatisfactionDialog.collectData$countExistingFiles(allExternalModulePaths, "build.gradle.kts");
        Object object = this.getGradleVersion();
        if (object == null || (object = object.getVersion()) == null) {
            object = gradleVersion = "UNKNOWN";
        }
        if ((string = (String)((Object)CollectionsKt.maxOrNull((Iterable)this.getKotlinVersions()))) == null) {
            string = "UNKNOWN";
        }
        String kotlinVersion = string;
        LocalDate localDate = KotlinNewUserTracker.Companion.getInstance().getInstallationDate();
        int daysOfIdeaUsage = localDate != null ? this.daysSinceDate(localDate) : 0;
        LocalDate localDate2 = KotlinNewUserTracker.Companion.getInstance().getFirstKotlinUsageDate();
        int daysOfKotlinUsage = localDate2 != null ? this.daysSinceDate(localDate2) : 0;
        LocalDate localDate3 = BuildProcessSatisfactionSurveyStore.Companion.getInstance().getFirstKotlinGradleUsageDate$kotlin_onboarding_gradle();
        int daysOfKotlinWithGradleUsage = localDate3 != null ? this.daysSinceDate(localDate3) : 0;
        LocalDate localDate4 = BuildProcessSatisfactionSurveyStore.Companion.getInstance().getFirstGradleUsageDate$kotlin_onboarding_gradle();
        int daysOfGradleUsage = localDate4 != null ? this.daysSinceDate(localDate4) : 0;
        CommonFeedbackSystemData commonFeedbackSystemData = CommonFeedbackSystemData.Companion.getCurrentData();
        return new BuildProcessSatisfactionDialogData((String)gradleVersion, kotlinVersion, groovyCount, ktsCount, daysOfIdeaUsage, daysOfKotlinUsage, daysOfKotlinWithGradleUsage, daysOfGradleUsage, commonFeedbackSystemData);
    }

    @NotNull
    protected BuildProcessSatisfactionDialogData getMySystemInfoData() {
        Lazy lazy = this.mySystemInfoData$delegate;
        return (BuildProcessSatisfactionDialogData)lazy.getValue();
    }

    @NotNull
    public String getZendeskTicketTitle() {
        return this.zendeskTicketTitle;
    }

    @NotNull
    public String getZendeskFeedbackType() {
        return this.zendeskFeedbackType;
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    protected boolean shouldAutoCloseZendeskTicket() {
        return false;
    }

    @NotNull
    protected Function0<Unit> getMyShowFeedbackSystemInfoDialog() {
        return this.myShowFeedbackSystemInfoDialog;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    protected void showThanksNotification() {
        new ThanksForFeedbackNotification(null, GradleFeedbackBundle.INSTANCE.message("dialog.build.process.gradle.satisfaction.feedback.content", new Object[0]), 1, null).notify(this.getMyProject());
    }

    private static final int collectData$countExistingFiles(Set<Path> allExternalModulePaths, String filename) {
        int n;
        Iterable $this$count$iv = allExternalModulePaths;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Path path2 = (Path)element$iv;
                boolean bl = false;
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                Path path3 = path2.resolve(filename);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                if (!(virtualFileManager.findFileByNioPath(path3) != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private static final BuildProcessSatisfactionDialogData mySystemInfoData_delegate$lambda$4(BuildProcessSatisfactionDialog this$0) {
        return this$0.collectData();
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$5(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.getMySystemInfoData().getGradleVersion());
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$6(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.getMySystemInfoData().getKotlinVersion());
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$7(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf(this$0.getMySystemInfoData().getGroovyBuildFileCount()));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$8(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf(this$0.getMySystemInfoData().getKtsBuildFileCount()));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$9(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf(this$0.getMySystemInfoData().getDaysOfKotlinUsage()));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$10(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf(this$0.getMySystemInfoData().getDaysOfIdeaUsage()));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$11(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf(this$0.getMySystemInfoData().getDaysOfGradleUsage()));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$12(BuildProcessSatisfactionDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf(this$0.getMySystemInfoData().getDaysOfKotlinWithGradleUsage()));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14$lambda$13(BuildProcessSatisfactionDialog this$0, Panel $this$showFeedbackSystemInfoDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.gradle.version", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$5(this$0, arg_0));
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.kotlin.version", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$6(this$0, arg_0));
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.groovy.build.file.count", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$7(this$0, arg_0));
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.kts.build.file.count", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$8(this$0, arg_0));
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.days.of.kotlin.usage", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$9(this$0, arg_0));
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.days.of.idea.usage", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$10(this$0, arg_0));
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.days.of.gradle.usage", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$11(this$0, arg_0));
        $this$showFeedbackSystemInfoDialog.row(GradleFeedbackBundle.INSTANCE.message("build.process.info.days.of.kotlin.gradle.usage", new Object[0]), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13$lambda$12(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$14(BuildProcessSatisfactionDialog this$0) {
        BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)this$0.getMyProject(), (CommonFeedbackSystemData)this$0.getMySystemInfoData().getCommonData(), arg_0 -> BuildProcessSatisfactionDialog.myShowFeedbackSystemInfoDialog$lambda$14$lambda$13(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

