/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;

public class KotlinDeprecatedMethodFilter
extends CoverageFilter {
    private boolean myShouldIgnore;

    public boolean isApplicable(InstrumentationData context) {
        return KotlinUtils.isKotlinClass(context);
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        void var2_3;
        void var1_1;
        AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
        if (!"Lkotlin/Deprecated;".equals(var1_1)) {
            return av;
        }
        return new AnnotationVisitor(this, 589824, (AnnotationVisitor)var2_3){
            final /* synthetic */ KotlinDeprecatedMethodFilter this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2, (AnnotationVisitor)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            public void visitEnum(String name, String descriptor, String value) {
                void var3_3;
                void var2_2;
                void var1_1;
                super.visitEnum((String)var1_1, descriptor, value);
                if (!"Lkotlin/DeprecationLevel;".equals(var2_2)) {
                    return;
                }
                if (("ERROR".equals(value) || "HIDDEN".equals(var3_3)) && !this.this$0.myShouldIgnore) {
                    KotlinDeprecatedMethodFilter.access$002(this.this$0, true);
                }
            }
        };
    }

    public void visitCode() {
        super.visitCode();
        if (this.myShouldIgnore) {
            this.myContext.getProjectContext().getFilteredStorage().addIgnoredMethod(this.myContext.get(Key.CLASS_NAME), this.myContext.getMethodName() + this.myContext.getMethodDesc());
        } else {
            boolean bl = this.myShouldIgnore = !this.myContext.getProjectContext().getFilteredStorage().checkMethodIncluded(this.myContext);
        }
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(true);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(KotlinDeprecatedMethodFilter x0, boolean x1) {
        void var1_1;
        x0.myShouldIgnore = var1_1;
        return x0.myShouldIgnore;
    }
}

