/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;

public class LimitContainer {
    private final int maxDirectNodeCount;
    @NotNull
    private final AtomicLong directNodeCount;
    private final int ssaConstructorSparseExRecordCount;

    public LimitContainer(@NotNull Map<String, Object> properties) {
        if (properties == null) {
            LimitContainer.$$$reportNull$$$0(0);
        }
        this.directNodeCount = new AtomicLong();
        this.maxDirectNodeCount = (Integer)properties.getOrDefault("mdnc", -1);
        this.ssaConstructorSparseExRecordCount = (Integer)properties.getOrDefault("mdvnc", -1);
    }

    public void incrementAndCheckDirectNodeCount(@NotNull ControlFlowGraph graph) {
        if (graph == null) {
            LimitContainer.$$$reportNull$$$0(1);
        }
        long newValue = this.directNodeCount.addAndGet(graph.getBlocks().size());
        if (this.maxDirectNodeCount != -1 && newValue >= (long)this.maxDirectNodeCount) {
            throw new LimitExceededDecompilerException(this.maxDirectNodeCount, newValue, "direct nodes");
        }
    }

    public void checkSFormsFastMapDirect(@NotNull Map<String, SFormsFastMapDirect> inVarVersions, @NotNull Map<String, SFormsFastMapDirect> outVarVersions) {
        if (inVarVersions == null) {
            LimitContainer.$$$reportNull$$$0(2);
        }
        if (outVarVersions == null) {
            LimitContainer.$$$reportNull$$$0(3);
        }
        int newValue = inVarVersions.size() + outVarVersions.size();
        if (this.ssaConstructorSparseExRecordCount != -1 && newValue > this.ssaConstructorSparseExRecordCount) {
            throw new LimitExceededDecompilerException(this.ssaConstructorSparseExRecordCount, newValue, "variable nodes");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inVarVersions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outVarVersions";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/java/decompiler/main/collectors/LimitContainer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "incrementAndCheckDirectNodeCount";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSFormsFastMapDirect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class LimitExceededDecompilerException
    extends RuntimeException {
        public LimitExceededDecompilerException(long limit, long actualValue, String type) {
            super("Limits for %s are exceeded. Current value: %s, limit: %s".formatted(type, actualValue, limit));
        }
    }
}

