/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldHaveCauseInstance
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveCauseInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        return actual.getCause() == null ? new ShouldHaveCauseInstance(expectedCauseType, actual) : new ShouldHaveCauseInstance(actual, expectedCauseType);
    }

    private ShouldHaveCauseInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        super("%nExpecting a throwable with cause being an instance of:%n  %s%nbut was an instance of:%n  %s%nThrowable that failed the check:%n%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseType, actual.getCause().getClass());
    }

    private ShouldHaveCauseInstance(Class<? extends Throwable> expectedCauseType, Throwable actual) {
        super("%nExpecting a throwable with cause being an instance of:%n  %s%nbut current throwable has no cause.%nThrowable that failed the check:%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseType);
    }
}

