/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.KonanExternalToolFailure;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0006\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020\"J \u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0002J\b\u0010*\u001a\u00020\u0017H\u0002J \u0010+\u001a\u00020\u00002\u0018\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0016\u0012\u0004\u0012\u00020\u00170\u0015J\b\u0010-\u001a\u00020(H\u0016J\r\u0010.\u001a\u00020\u0000*\u00020\u0003H\u0086\u0002J\u0013\u0010.\u001a\u00020\u0000*\b\u0012\u0004\u0012\u00020\u00030\tH\u0086\u0002R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR.\u0010\u0014\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/konan/exec/Command;", "", "tool", "", "(Ljava/lang/String;)V", "command", "", "([Ljava/lang/String;)V", "initialCommand", "", "redirectInputFile", "Ljava/io/File;", "(Ljava/util/List;Ljava/io/File;)V", "args", "getArgs", "()Ljava/util/List;", "argsWithExecutable", "getArgsWithExecutable", "", "getCommand", "logger", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "getLogger", "()Lkotlin/jvm/functions/Function1;", "setLogger", "(Lkotlin/jvm/functions/Function1;)V", "getRedirectInputFile", "()Ljava/io/File;", "stdError", "execute", "getOutputLines", "withErrors", "", "getResult", "Lorg/jetbrains/kotlin/konan/exec/Command$Result;", "handleError", "handleExitCode", "code", "", "output", "log", "logWith", "newLogger", "runProcess", "unaryPlus", "Result", "kotlin-native-utils"})
@SourceDebugExtension(value={"SMAP\nExecuteCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecuteCommand.kt\norg/jetbrains/kotlin/konan/exec/Command\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public class Command {
    @Nullable
    private final File redirectInputFile;
    @NotNull
    private final List<String> command;
    @NotNull
    private final List<String> argsWithExecutable;
    @Nullable
    private Function1<? super Function0<String>, Unit> logger;
    @NotNull
    private List<String> stdError;

    public Command(@NotNull List<String> initialCommand, @Nullable File redirectInputFile) {
        Intrinsics.checkNotNullParameter(initialCommand, (String)"initialCommand");
        this.redirectInputFile = redirectInputFile;
        this.command = CollectionsKt.toMutableList((Collection)initialCommand);
        this.argsWithExecutable = this.command;
        this.stdError = CollectionsKt.emptyList();
    }

    public /* synthetic */ Command(List list, File file2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        this(list, file2);
    }

    @Nullable
    public final File getRedirectInputFile() {
        return this.redirectInputFile;
    }

    public Command(@NotNull String tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        this(CollectionsKt.listOf((Object)tool), null, 2, null);
    }

    public Command(String ... command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this(ArraysKt.toList((Object[])command), null, 2, null);
    }

    @NotNull
    protected final List<String> getCommand() {
        return this.command;
    }

    @NotNull
    public final List<String> getArgsWithExecutable() {
        return this.argsWithExecutable;
    }

    @NotNull
    public final List<String> getArgs() {
        return CollectionsKt.drop((Iterable)this.command, (int)1);
    }

    @NotNull
    public final Command unaryPlus(@NotNull String $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        ((Collection)this.command).add($this$unaryPlus);
        return this;
    }

    @NotNull
    public final Command unaryPlus(@NotNull List<String> $this$unaryPlus) {
        Intrinsics.checkNotNullParameter($this$unaryPlus, (String)"<this>");
        this.command.addAll((Collection<String>)$this$unaryPlus);
        return this;
    }

    @Nullable
    public final Function1<Function0<String>, Unit> getLogger() {
        return this.logger;
    }

    public final void setLogger(@Nullable Function1<? super Function0<String>, Unit> function1) {
        this.logger = function1;
    }

    @NotNull
    public final Command logWith(@NotNull Function1<? super Function0<String>, Unit> newLogger) {
        Intrinsics.checkNotNullParameter(newLogger, (String)"newLogger");
        this.logger = newLogger;
        return this;
    }

    public int runProcess() {
        this.stdError = CollectionsKt.emptyList();
        ProcessBuilder builder = new ProcessBuilder(this.command);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        if (this.redirectInputFile == null) {
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        } else {
            builder.redirectInput(this.redirectInputFile);
        }
        Process process = builder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        this.stdError = TextStreamsKt.readLines((Reader)reader);
        int exitCode = process.waitFor();
        return exitCode;
    }

    public void execute() {
        this.log();
        int code = this.runProcess();
        this.handleExitCode(code, this.stdError);
    }

    @NotNull
    public final List<String> getOutputLines(boolean withErrors) {
        return this.getResult(withErrors, true).getOutputLines();
    }

    public static /* synthetic */ List getOutputLines$default(Command command, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOutputLines");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return command.getOutputLines(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Result getResult(boolean withErrors, boolean handleError) {
        this.log();
        File outputFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        outputFile.deleteOnExit();
        try {
            ProcessBuilder builder = new ProcessBuilder(this.command);
            if (this.redirectInputFile == null) {
                builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            } else {
                builder.redirectInput(this.redirectInputFile);
            }
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            builder.redirectOutput(ProcessBuilder.Redirect.to(outputFile)).redirectErrorStream(withErrors);
            Process process = builder.start();
            int code = process.waitFor();
            if (handleError) {
                Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
                this.handleExitCode(code, FilesKt.readLines$default((File)outputFile, null, (int)1, null));
            }
            Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
            Result result2 = new Result(code, FilesKt.readLines$default((File)outputFile, null, (int)1, null));
            return result2;
        }
        finally {
            outputFile.delete();
        }
    }

    public static /* synthetic */ Result getResult$default(Command command, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getResult");
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return command.getResult(bl, bl2);
    }

    private final void handleExitCode(int code, List<String> output) {
        block4: {
            Unit unit;
            String string2;
            if (code != 0) {
                throw new KonanExternalToolFailure(StringsKt.trimIndent((String)("\n            The " + this.command.get(0) + " command returned non-zero exit code: " + code + ".\n            output:\n            ")) + '\n' + CollectionsKt.joinToString$default((Iterable)output, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), this.command.get(0), null, 4, null);
            }
            if (!(!((Collection)this.stdError).isEmpty())) break block4;
            String message = string2 = CollectionsKt.joinToString$default((Iterable)this.stdError, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean bl = false;
            Function1<? super Function0<String>, Unit> function1 = this.logger;
            if (function1 != null) {
                Function1<? super Function0<String>, Unit> it = function1;
                boolean bl2 = false;
                it.invoke((Object)new Function0<String>(message){
                    final /* synthetic */ String $message;
                    {
                        this.$message = $message;
                        super(0);
                    }

                    public final String invoke() {
                        return this.$message;
                    }
                });
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                System.out.println((Object)message);
            }
        }
    }

    static /* synthetic */ void handleExitCode$default(Command command, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleExitCode");
        }
        if ((n2 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        command.handleExitCode(n, list);
    }

    private final void log() {
        if (this.logger != null) {
            Function1<? super Function0<String>, Unit> function1 = this.logger;
            Intrinsics.checkNotNull(function1);
            function1.invoke((Object)new Function0<String>(this){
                final /* synthetic */ Command this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final String invoke() {
                    return CollectionsKt.joinToString$default((Iterable)this.this$0.getCommand(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                }
            });
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/konan/exec/Command$Result;", "", "exitCode", "", "outputLines", "", "", "(ILjava/util/List;)V", "getExitCode", "()I", "getOutputLines", "()Ljava/util/List;", "kotlin-native-utils"})
    public static final class Result {
        private final int exitCode;
        @NotNull
        private final List<String> outputLines;

        public Result(int exitCode, @NotNull List<String> outputLines) {
            Intrinsics.checkNotNullParameter(outputLines, (String)"outputLines");
            this.exitCode = exitCode;
            this.outputLines = outputLines;
        }

        public final int getExitCode() {
            return this.exitCode;
        }

        @NotNull
        public final List<String> getOutputLines() {
            return this.outputLines;
        }
    }
}

