/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.refactoring.rename.PropertyForRename;
import org.jetbrains.plugins.groovy.refactoring.rename.RenamePropertyUtil;

public final class RenameGroovyPropertyProcessor
extends RenamePsiElementProcessor {
    Logger LOG = Logger.getInstance(RenameGroovyPropertyProcessor.class);

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenameGroovyPropertyProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            RenameGroovyPropertyProcessor.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            RenameGroovyPropertyProcessor.$$$reportNull$$$0(2);
        }
        this.LOG.assertTrue(element instanceof PropertyForRename);
        List<? extends PsiElement> elementsToRename = ((PropertyForRename)element).getElementsToRename();
        for (PsiElement psiElement : elementsToRename) {
            if (psiElement instanceof GrField) {
                allRenames.put(psiElement, newName);
                continue;
            }
            if (!(psiElement instanceof GrMethod)) continue;
            if (GroovyPropertyUtils.isSimplePropertyGetter((PsiMethod)psiElement)) {
                allRenames.put(psiElement, RenamePropertyUtil.getGetterNameByOldName(newName, ((PsiMethod)psiElement).getName()));
                continue;
            }
            allRenames.put(psiElement, GroovyPropertyUtils.getSetterName(newName));
        }
        allRenames.remove(element);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (element == null) {
            RenameGroovyPropertyProcessor.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            RenameGroovyPropertyProcessor.$$$reportNull$$$0(4);
        }
        if (usages == null) {
            RenameGroovyPropertyProcessor.$$$reportNull$$$0(5);
        }
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            RenameGroovyPropertyProcessor.$$$reportNull$$$0(6);
        }
        return element instanceof PropertyForRename;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/rename/RenameGroovyPropertyProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRenaming";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renameElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canProcessElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

