.TH VPTOVF 1 "30 January 2026" "Web2C @VERSION@"
.\"=====================================================================
.if t .ds TX \fRT\\h'-0.10m'\\v'0.17v'E\\v'-0.17v'\\h'-0.06m'X\fP
.if n .ds TX TeX
.\"=====================================================================
.SH NAME
vptovf \- convert TeX virtual property list (vpl) files to virtual font metric (vf) files
.SH SYNOPSIS
.B vptovf
.RB [ -verbose ]
.IR vpl_file [ \fB.vpl\fP ]
.RI [ vfm_file [ \fB.vf\fP ]
.RI [ tfm_file [ \fB.tfm\fP ]]]
.\"=====================================================================
.SH DESCRIPTION
The
.B vptovf
program translates a (plain text) property list file to a pair of
(binary) files in vf (virtual font) and tfm (\*(TX font metric) formats.
Thus, a virtual font file can be edited and its exact contents can be
displayed mnemonically. New virtual fonts, which map characters as seen
by \*(TX into an arbitrary sequence of low-level typesetting operations,
can also be created in this way. See \fBvftovp\fP(1) for detailed
references on virtual fonts.
.PP
All three filenames,
.IR vpl_file ,
.IR vf_file ,
and
.IR tfm_file ,
are extended with the appropriate suffix if necessary. No path searching
is done for the \fIvpl_file\fP.
.\"=====================================================================
.SH OPTIONS
By default, the program operates silently. With \fB-verbose\fP, some
reports are written to stdout.
The standard
.B -help
and
.B -version
options are also supported.
.PP
Font utility topic on CTAN: https://ctan.org/topic/font-util
.br
Package page on CTAN: https://ctan.org/pkg/vptovf
.br
Section in the Web2c manual:
https://tug.org/texinfohtml/web2c.html#vptovf-invocation
.br
Typeset source code, including the vpl file format description:
https://ctan.org/pkg/knuth-pdf
.\"=====================================================================
.SH "SEE ALSO"
.BR pltotf (1),
.BR tftopl (1),
.BR vftovp (1).
.\"=====================================================================
.SH AUTHORS
Donald E. Knuth wrote the program, based in part on an idea of David Fuchs,
starting with the code for
.BR pltotf (1).
Karl Berry adapted it for compilation with
.BR web2c .
.PP
Public discussion list and bug reports: https://lists.tug.org/tex-k
