% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KnockoffSampler.R
\name{KnockoffSampler}
\alias{KnockoffSampler}
\title{Knockoff Sampler}
\description{
Implements conditional sampling using Knockoffs.
}
\details{
The \code{KnockoffSampler} samples \link[knockoff:knockoff]{Knockoffs} based on the task data.
This class allows arbitrary \code{knockoff_fun}, which also means that no input checking
against supported feature types can be done. Use \link{KnockoffGaussianSampler} for the
Gaussian knockoff sampler for numeric features.
Alternative knockoff samplers include \code{knockoff_seq()} from the \code{seqknockoff} package
available on GitHub: \url{https://github.com/kormama1/seqknockoff}.

Knockoffs are related to the \code{ConditionalSampler} familty, with key differences:
They do not allow specifying a \code{conditioning_set}
}
\examples{
\dontshow{if (requireNamespace("knockoff", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(mlr3)
task = tgen("2dnormals")$generate(n = 100)
# Create sampler with default parameters
sampler = KnockoffSampler$new(task)
# Sample using row_ids from stored task
sampled_data = sampler$sample("x1")
\dontshow{\}) # examplesIf}
}
\references{
Watson D, Wright M (2021).
\dQuote{Testing Conditional Independence in Supervised Learning Algorithms.}
\emph{Machine Learning}, \bold{110}(8), 2107--2129.
\doi{10.1007/s10994-021-06030-6}.

Blesch K, Watson D, Wright M (2023).
\dQuote{Conditional Feature Importance for Mixed Data.}
\emph{AStA Advances in Statistical Analysis}, \bold{108}(2), 259--278.
\doi{10.1007/s10182-023-00477-9}.
}
\section{Super class}{
\code{\link[xplainfi:FeatureSampler]{xplainfi::FeatureSampler}} -> \code{KnockoffSampler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{x_tilde}}{Knockoff matrix with one (or \code{iters}) row(s) per original observation in \code{task}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KnockoffSampler-new}{\code{KnockoffSampler$new()}}
\item \href{#method-KnockoffSampler-sample}{\code{KnockoffSampler$sample()}}
\item \href{#method-KnockoffSampler-clone}{\code{KnockoffSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="print"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-print'><code>xplainfi::FeatureSampler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="sample_newdata"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-sample_newdata'><code>xplainfi::FeatureSampler$sample_newdata()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnockoffSampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-KnockoffSampler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of the KnockoffSampler class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnockoffSampler$new(
  task,
  knockoff_fun = function(x) knockoff::create.second_order(as.matrix(x)),
  iters = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task}) Task to sample from}

\item{\code{knockoff_fun}}{(\code{function}) Function used to create knockoff matrix. Default are second-order Gaussian knockoffs (\code{knockoff::create.second_order()})}

\item{\code{iters}}{(\code{integer(1)}: \code{1}) Number of repetitions the \code{knockoff_fun} is applied to create multiple \code{x_tilde}
instances per observation.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnockoffSampler-sample"></a>}}
\if{latex}{\out{\hypertarget{method-KnockoffSampler-sample}{}}}
\subsection{Method \code{sample()}}{
Sample from stored task using knockoff values. Replaces specified feature(s) with
their knockoff counterparts from the pre-generated knockoff matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnockoffSampler$sample(feature, row_ids = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{(\code{character}) Feature(s) to sample.}

\item{\code{row_ids}}{(\code{integer()} | \code{NULL}) Row IDs to use. If \code{NULL}, uses all rows.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified copy with knockoff feature(s).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KnockoffSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KnockoffSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KnockoffSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
