% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{mean_cl_boot}
\alias{mean_cl_boot}
\title{Compute confidence interval of mean by bootstrapping.}
\usage{
mean_cl_boot(
  x,
  conf = 0.95,
  type = "basic",
  nrepl = 10^3,
  round = FALSE,
  roundDig = 2
)
}
\arguments{
\item{x}{Data for computation.}

\item{conf}{confidence interval with default 95\%.}

\item{type}{type for function boot.ci.}

\item{nrepl}{number of bootstrap replications, defaults to 1000.}

\item{round}{logical, applies \link{roundR} function to results. Output is character.}

\item{roundDig}{Number of relevant digits for function \link{roundR}.}
}
\value{
A tibble with one row and three columns: Mean, CIlow, CIhigh.
}
\description{
\code{mean_cl_boot} computes lower and upper confidence limits for the
estimated mean, based on bootstrapping.
}
\examples{
# basic usage of mean_cl_boot
mean_cl_boot(x = mtcars$wt)
}
