% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{textmodel_word2vec}
\alias{textmodel_word2vec}
\title{Word2vec model}
\usage{
textmodel_word2vec(
  x,
  dim = 50,
  type = c("cbow", "sg", "dm"),
  min_count = 5,
  window = ifelse(type == "sg", 10, 5),
  iter = 10,
  alpha = 0.05,
  model = NULL,
  use_ns = TRUE,
  ns_size = 5,
  sample = 0.001,
  tolower = TRUE,
  include_data = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{a \link[quanteda:tokens]{quanteda::tokens} or \link[quanteda:tokens_xptr]{quanteda::tokens_xptr} object.}

\item{dim}{the size of the word vectors.}

\item{type}{the architecture of the model; either "cbow" (continuous back-of-words),
"sg" (skip-gram), or "dm" (distributed memory).}

\item{min_count}{the minimum frequency of the words. Words less frequent than
this in \code{x} are removed before training.}

\item{window}{the size of the word window. Words within this window are considered
to be the context of a target word.}

\item{iter}{the number of iterations in model training.}

\item{alpha}{the initial learning rate.}

\item{model}{a trained Word2vec model; if provided, its word vectors are updated for \code{x}.}

\item{use_ns}{if \code{TRUE}, negative sampling is used. Otherwise, hierarchical softmax
is used.}

\item{ns_size}{the size of negative samples. Only used when \code{use_ns = TRUE}.}

\item{sample}{the rate of sampling of words based on their frequency. Sampling is
disabled when \code{sample = 1.0}}

\item{tolower}{lower-case all the tokens before fitting the model.}

\item{include_data}{if \code{TRUE}, the resulting object includes the data supplied as \code{x}.}

\item{verbose}{if \code{TRUE}, print the progress of training.}

\item{...}{additional arguments.}
}
\value{
Returns a textmodel_word2vec object with the following elements:
\item{values}{a list of a matrix for word vector values.}
\item{weights}{a matrix for word vector weights.}
\item{dim}{the size of the word vectors.}
\item{type}{the architecture of the model.}
\item{frequency}{the frequency of words in \code{x}.}
\item{window}{the size of the word window.}
\item{iter}{the number of iterations in model training.}
\item{alpha}{the initial learning rate.}
\item{use_ns}{the use of negative sampling.}
\item{ns_size}{the size of negative samples.}
\item{min_count}{the value of min_count.}
\item{concatenator}{the concatenator in \code{x}.}
\item{data}{the original data supplied as \code{x} if \code{include_data = TRUE}.}
\item{call}{the command used to execute the function.}
\item{version}{the version of the wordvector package.}
}
\description{
Train a word2vec model (Mikolov et al., 2013) using a \link[quanteda:tokens]{quanteda::tokens} object.
}
\details{
If \code{type = "dm"}, it trains a doc2vec model but saves only
word vectors to save storage space. \link{textmodel_doc2vec} should be
used to access document vectors.

Users can changed the number of processors used for the parallel computing via
\code{options(wordvector_threads)}.
}
\examples{
\donttest{
library(quanteda)
library(wordvector)

# pre-processing
corp <- data_corpus_news2014 
toks <- tokens(corp, remove_punct = TRUE, remove_symbols = TRUE) \%>\% 
   tokens_remove(stopwords("en", "marimo"), padding = TRUE) \%>\% 
   tokens_select("^[a-zA-Z-]+$", valuetype = "regex", case_insensitive = FALSE,
                 padding = TRUE) \%>\% 
   tokens_tolower()

# train word2vec
wov <- textmodel_word2vec(toks, dim = 50, type = "cbow", min_count = 5, sample = 0.001)

# find similar words
head(similarity(wov, c("berlin", "germany", "france"), mode = "words"))
head(similarity(wov, c("berlin" = 1, "germany" = -1, "france" = 1), mode = "values"))
head(similarity(wov, analogy(~ berlin - germany + france), mode = "words"))
}
}
\references{
Mikolov, T., Sutskever, I., Chen, K., Corrado, G., & Dean, J. (2013).
Distributed Representations of Words and Phrases and their Compositionality.
https://arxiv.org/abs/1310.4546.
}
