% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_with_ci.R
\name{roc_with_ci}
\alias{roc_with_ci}
\title{ROC related computations -- internal function}
\usage{
roc_with_ci(
  probs,
  labels,
  positive,
  auc,
  ci_method = c("none", "hanley", "bootstrap"),
  n_boot = 1000,
  alpha = 0.05
)
}
\arguments{
\item{probs}{Vector of class probabilities or values of continuous predictor}

\item{labels}{Vector, factor with two levels}

\item{positive}{Character giving the level that corresponds to 'case'}

\item{auc}{Numeric value of AUC}

\item{ci_method}{Character from c("none", "hanley", "bootstrap")}

\item{n_boot}{Numeric value giving the number of bootstrap replicates (default: 1000)}

\item{alpha}{Level of significance (default: 0.05)}
}
\value{
List with components:
\item{roc_df}{data frame for plotting ROC curve}
\item{roc_band}{data frame for plotting confidence band of ROC}
\item{auc}{auc}
\item{auc_ci}{confint for auc}
}
\description{
ROC related computations -- internal function
}
\keyword{internal}
