% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_time_in_daylight}
\alias{wbt_time_in_daylight}
\title{Time in daylight}
\usage{
wbt_time_in_daylight(
  dem,
  output,
  lat,
  long,
  az_fraction = 10,
  max_dist = 100,
  utc_offset = "00:00",
  start_day = 1,
  end_day = 365,
  start_time = "00:00:00",
  end_time = "23:59:59",
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{lat}{Centre point latitude.}

\item{long}{Centre point longitude.}

\item{az_fraction}{Azimuth fraction in degrees.}

\item{max_dist}{Optional maximum search distance. Minimum value is 5 x cell size.}

\item{utc_offset}{UTC time offset, in hours (e.g. -04:00, +06:00).}

\item{start_day}{Start day of the year (1-365).}

\item{end_day}{End day of the year (1-365).}

\item{start_time}{Starting hour to track shadows (e.g. 5, 5:00, 05:00:00). Assumes 24-hour time: HH:MM:SS. 'sunrise' is also a valid time.}

\item{end_time}{Ending hour to track shadows (e.g. 21, 21:00, 21:00:00). Assumes 24-hour time: HH:MM:SS. 'sunset' is also a valid time.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates the proportion of time a location is not within an area of shadow.
}
\keyword{GeomorphometricAnalysis}
