% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmplotting_helpers.R
\name{add_median_annotation}
\alias{add_median_annotation}
\title{Add median annotation to KM plot}
\usage{
add_median_annotation(
  medians_df,
  med.digits,
  med.cex,
  med.font,
  xmed.fraction,
  ymed.offset
)
}
\arguments{
\item{medians_df}{Data frame with quantile results. Should contain columns \code{quantile}, \code{lower}, \code{upper}, and \code{group}.}

\item{med.digits}{Integer; number of digits to display for median and confidence interval.}

\item{med.cex}{Numeric; text size for median annotation.}

\item{med.font}{Integer; font for median annotation.}

\item{xmed.fraction}{Numeric; fraction of the x-axis for annotation placement (e.g., 0.8 for 80\\\% to the right).}

\item{ymed.offset}{Numeric; offset from the top of the plot for annotation placement.}
}
\value{
Invisibly returns NULL. Used for plotting side effects.
}
\description{
Adds median survival annotation to a Kaplan-Meier plot.
}
