% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{vtreeOutput}
\alias{vtreeOutput}
\title{vtree widget}
\usage{
vtreeOutput(outputId, width = "100\%", height = "100\%")
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{must be a valid CSS unit in pixels
or a number, which will be coerced to a string and have \code{"px"} appended.}
}
\description{
Shiny bindings for vtree. It is actually a wrapper around \code{\link[DiagrammeR]{grViz}}.
}
\examples{
\dontrun{
library(shiny)
library(vtree)

ui <- fluidPage(
  vtreeOutput("vtree", width = "100\%", height = "800px")
)

server <- function(input, output, session) {
  output$vtree <- renderVtree({
    vtree(FakeData,"Severity Sex",
          labelnode=list(Sex=(c("Male"="M","Female"="F"))),
          pngknit=FALSE)
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link{renderVtree}}

Other Shiny Functions: 
\code{\link{init_js}()},
\code{\link{inlineCssSetup}()},
\code{\link{renderVtree}()},
\code{\link{use_svgzoom}()}
}
\concept{Shiny Functions}
