% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{adjust_p}
\alias{adjust_p}
\title{Adjust p-values from multiple tests and optionally annotate significance stars}
\usage{
adjust_p(df, col, method = "fdr", digits = 3, stars = TRUE)
}
\arguments{
\item{df}{A data frame or tibble containing the column to adjust.}

\item{col}{A tidyselect expression specifying the p-value column to adjust.}

\item{method}{Character string specifying the p-value adjustment method.
See \code{\link[stats]{p.adjust}} for available methods. Disable adjustment with FALSE.}

\item{digits}{Integer; number of decimal places for rounding.}

\item{stars}{Logical or character; if \code{TRUE}, add a "stars" column
with significance symbols (e.g., \code{"***"}, \code{"**"}, \code{"*"})
based on the adjusted p-values.
If set to a character value it determines the new column name.}
}
\value{
A modified data frame with:
\itemize{
\item Adjusted p-values in the selected column.
\item (Optionally) a new column \code{stars} containing significance symbols.
\item An attribute \code{"adjust"} on the data frame storing the method.
\item A \code{"round"} attribute on the p-value column.
}
}
\description{
Adjust p-values from multiple tests and optionally annotate significance stars
}
\keyword{internal}
