% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{add_model}
\alias{add_model}
\title{Add a column with predicted values from a regression model}
\usage{
add_model(
  data,
  col,
  categorical,
  metric,
  interactions = NULL,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The target column holding metric values.}

\item{categorical}{A tidy column selection holding categorical variables.}

\item{metric}{A tidy column selection holding metric variables.}

\item{interactions}{A vector of interaction effects to calculate.
Each interaction effect should be provided as multiplication of the variables.
The interaction effect can be provided as character value (e.g. \code{c("sd_gender * adopter")})
or as unquoted column names (e.g. \code{c(sd_gender * adopter)}).}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_metrics}.}
}
\value{
The input tibble with one additional column.
The new column name is derived from the target column, prefixed with "prd_".
The new column will have an attribute "lm.fit" with the fit model.
}
\description{
The regression output comes from \code{stats::\link[stats:lm]{lm}}.
The effect sizes are calculated by \code{heplots::\link[heplots:etasq]{etasq}}.
The variance inflation is calculated by \code{car::\link[car:vif]{vif}}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- filter(volker::chatgpt, sd_gender != "diverse")

data <- data |>
  add_model(use_work, categorical = c(sd_gender, adopter), metric = sd_age)

}
\keyword{internal}
