% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{add_factors}
\alias{add_factors}
\title{Add PCA columns along with summary statistics (KMO and Bartlett test) to a data frame}
\usage{
add_factors(data, cols, newcols = NULL, k = 2, method = "pca", clean = TRUE)
}
\arguments{
\item{data}{A dataframe.}

\item{cols}{A tidy selection of item columns.}

\item{newcols}{Names of the factor columns as a character vector.
Must be the same length as k or NULL.
Set to NULL (default) to automatically build a name
from the common column prefix, prefixed with "fct_", postfixed with the factor number.}

\item{k}{Number of factors to calculate.
Set to NULL to calculate eigenvalues for all components up to the number of items
and automatically choose k. Eigenvalues and the decision on k are calculated by
\code{psych::\link[psych:fa.parallel]{fa.parallel}}.}

\item{method}{The method as character value. Currently, only pca is supported.}

\item{clean}{Prepare data by \link{data_clean}.}
}
\value{
The input tibble with additional columns containing factor values.
The new columns are prefixed with "fct_".
The first new column contains the fit result in the attribute psych.pca.fit.
The names of the items used for factor analysis are stored in the attribute psych.pca.items.
The summary diagnostics (Bartlett test and KMO) are stored in the attribute psych.kmo.bartlett.
}
\description{
PCA is performed using \code{psych::\link[psych:pca]{pca}} usind varimax rotation.
Bartlett's test for sphericity is calculated with \code{psych::\link[psych:cortest.bartlett]{cortest.bartlett}}.
The Kaiser-Meyer-Olkin (KMO) measure is computed using \code{psych::\link[psych:KMO]{KMO}}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
ds <- volker::chatgpt

volker::add_factors(ds, starts_with("cg_adoption"))
}
