% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_domain_comments.R
\name{get_domain_comments}
\alias{get_domain_comments}
\title{Retrieve comments for an Internet domain}
\usage{
get_domain_comments(domain = NULL, limit = limit, cursor = cursor, ...)
}
\arguments{
\item{domain}{domain name. String. Required.}

\item{limit}{Number of entries. Integer. Optional.  Default is 10.}

\item{cursor}{String. Optional.}

\item{\dots}{Additional arguments passed to \code{\link{virustotal_GET}}.}
}
\value{
named list with the following possible items: 
\code{`BitDefender category`, undetected_referrer_samples, whois_timestamp,
detected_downloaded_samples, detected_referrer_samples, `Webutation domain info`, `Alexa category`, undetected_downloaded_samples,
resolutions, detected_communicating_samples, `Opera domain info`, `TrendMicro category`, categories, domain_siblings, 
`BitDefender domain info`, whois, `Alexa domain info`, response_code, verbose_msg, `Websense ThreatSeeker category`, subdomains,
`WOT domain info`, detected_urls, `Alexa rank`, undetected_communicating_samples, `Dr.Web category`, pcaps}
}
\description{
Retrieve comments for an Internet domain
}
\examples{
\dontrun{

# Before calling the function, set the API key using set_key('api_key_here')
   
get_domain_comments("http://www.google.com")
get_domain_comments("http://www.goodsfwrfw.com") # Domain not found
}
}
\references{
\url{https://docs.virustotal.com/reference}
}
\seealso{
\code{\link{set_key}} for setting the API key
}
