% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_wear.R
\name{emis_wear}
\alias{emis_wear}
\title{Emission estimation from tyre, brake and road surface wear}
\usage{
emis_wear(
  veh,
  lkm,
  ef,
  what = "tyre",
  speed,
  agemax = ncol(veh),
  profile,
  hour = nrow(profile),
  day = ncol(profile)
)
}
\arguments{
\item{veh}{Object of class "Vehicles"}

\item{lkm}{Length of the road in km.}

\item{ef}{list of emission factor functions class "EmissionFactorsList",
length equals to hours.}

\item{what}{Character for indicating "tyre", "break" or "road"}

\item{speed}{Speed data-frame with number of columns as hours}

\item{agemax}{Age of oldest vehicles for that category}

\item{profile}{Numerical or dataframe with nrows equal to 24 and ncol
7 day of the week}

\item{hour}{Number of considered hours in estimation}

\item{day}{Number of considered days in estimation}
}
\value{
emission estimation  g/h
}
\description{
\code{emis_wear} estimates wear emissions. The sources are tyres,
breaks and road surface.
}
\examples{
\dontrun{
data(net)
data(pc_profile)
pc_week <- temp_fact(net$ldv[1:10] + net$hdv[1:10], pc_profile[, 1])
df <- netspeed(pc_week, net$ps[1:10], net$ffs[1:10],
              net$capacity[1:10], net$lkm[1:10], alpha = 1)
ef <- ef_wear(wear = "tyre", type = "PC", pol = "PM10", speed = df)
emi <- emis_wear(veh = age_ldv(net$ldv[1:10], name = "VEH"),
                 lkm = net$lkm[1:10], ef = ef, speed = df,
                 profile = pc_profile[, 1])
emi
}
}
\references{
Ntziachristos and Boulter 2016. Automobile tyre and break wear
and road abrasion. In: EEA, EMEP. EEA air pollutant emission inventory
guidebook-2009. European Environment Agency, Copenhagen, 2016
}
