% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_methods.R
\name{print.pb_regression}
\alias{print.pb_regression}
\title{Print method for pb_regression objects}
\usage{
\method{print}{pb_regression}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{pb_regression}.}

\item{digits}{Number of significant digits to display (default: 3).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns the input object.
}
\description{
Displays a concise summary of Passing-Bablok regression results, including
slope and intercept estimates with confidence intervals.
}
\examples{
set.seed(42)
method_a <- rnorm(50, mean = 100, sd = 15)
method_b <- 1.05 * method_a + 3 + rnorm(50, sd = 5)
pb <- pb_regression(method_a, method_b)
print(pb)

}
\seealso{
\code{\link[=summary.pb_regression]{summary.pb_regression()}} for detailed output
}
