% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_conservation_level.R
\name{plot_conservation_level}
\alias{plot_conservation_level}
\title{Conservation Levels Distribution Plot}
\usage{
plot_conservation_level(
  df,
  protein_order = NULL,
  conservation_label = 1,
  host = 1,
  base_size = 11,
  line_dot_size = 2,
  label_size = 2.6,
  alpha = 0.6
)
}
\arguments{
\item{df}{DiMA JSON converted csv file data}

\item{protein_order}{order of proteins displayed in plot}

\item{conservation_label}{0 (partial; show present conservation labels only) or 1 (full; show ALL conservation labels) in plot}

\item{host}{number of host (1/2)}

\item{base_size}{base font size in plot}

\item{line_dot_size}{lines and dots size}

\item{label_size}{conservation labels font size}

\item{alpha}{any number from 0 (transparent) to 1 (opaque)}
}
\value{
A plot
}
\description{
This function plots conservation levels distribution of k-mer positions, which consists of
completely conserved (black) (index incidence = 100\%), highly conserved (blue)
(90\% <= index incidence < 100\%), mixed variable (green) (20\% < index incidence <= 90\%),
highly diverse (purple) (10\% < index incidence <= 20\%) and
extremely diverse (pink) (index incidence <= 10\%).
}
\examples{
plot_conservation_level(proteins_1host, conservation_label = 1,alpha=0.8, base_size = 15)
plot_conservation_level(protein_2hosts, conservation_label = 0, host=2)
}
