% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uk_population_2019.R
\docType{data}
\name{uk_population_2019_by_5yr_age}
\alias{uk_population_2019_by_5yr_age}
\title{Country, regional, and sub-national population estimates by 5 year age groups}
\format{
An object of class \code{grouped_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 7562 rows and 6 columns.
}
\source{
\url{https://www.ons.gov.uk/peoplepopulationandcommunity/populationandmigration/populationestimates}

Originally licensed under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\usage{
data("uk_population_2019_by_5yr_age")
}
\description{
ONS National and sub-national mid-year population estimates for the UK and its
constituent countries by administrative area, age and sex (including
components of population change, median age and population density).
}
\details{
Mid-2019: April 2019 local authority district codes edition of this dataset,
this is UK wide and covers country, regions and LTLA (2019 boundaries)

Stratified by 5 year age groups
\subsection{\code{uk_population_2019_by_5yr_age} dataframe with 7562 rows and 6 columns}{

\describe{
\item{ \code{name} (chr) }{
The region name
}
\item{ \code{code} (chr) }{
The region code
}
\item{ \code{codeType} (chr) }{
The ONS geographical region code type (including year)
}
\item{ \code{class} (chr) }{
The age group in 5 year age bands
}
\item{ \code{population} (dbl) }{
the count of the population in that age group
}
\item{ \code{baseline_proportion} (dbl) }{
the proportion of the total regional population that is in an age group
}
}
}
}
\examples{
dplyr::glimpse(uk_population_2019_by_5yr_age)
}
\concept{datasets}
\keyword{datasets}
