% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/england_covid.R
\docType{data}
\name{england_cases_by_5yr_age}
\alias{england_cases_by_5yr_age}
\title{England only COVID-19 case counts stratified by 5-year age bands}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 26790 rows and 8 columns.
}
\source{
\url{https://ukhsa-dashboard.data.gov.uk/covid-19-archive-data-download}

Originally licensed under the \href{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}{Open Government Licence v3.0}
}
\usage{
data("england_cases_by_5yr_age")
}
\description{
A dataset of the daily count of COVID-19 cases by age group in England
downloaded from the UKHSA coronavirus API, and formatted for
use in \code{ggoutbreak}. A denominator is calculated which is the overall
positive count for all age groups. This data set can be used to calculate
group-wise incidence and absolute growth rates and group wise proportions and
relative growth rates by age group.
}
\details{
You may want \code{england_covid_positivity} instead which includes the
test denominator. The denominator here is the total number of positive
tests across all age groups and not the number of tests taken or population
size.
\subsection{\code{england_cases_by_5yr_age} dataframe with 26790 rows and 8 columns}{

\describe{
\item{ \code{name} (chr) }{
The region name
}
\item{ \code{code} (chr) }{
The region code
}
\item{ \code{codeType} (chr) }{
The ONS geographical region code type (including year)
}
\item{ \code{date} (date) }{
The date
}
\item{ \code{class} (chr) }{
the age group in 5 year age bands
}
\item{ \code{count} (dbl) }{
the test positives for each age group
}
\item{ \code{denom} (dbl) }{
the test positives across all age groups
}
\item{ \code{population} (dbl) }{
the population size for this age group
}
}
}
}
\examples{
dplyr::glimpse(england_cases_by_5yr_age)
}
\concept{datasets}
\keyword{datasets}
