% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covid-variants.R
\docType{data}
\name{covid_variants_ltla}
\alias{covid_variants_ltla}
\title{COG-UK counts of genomic variants by lower tier local authority}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 55785 rows and 8 columns.
}
\source{
\url{https://covid19.sanger.ac.uk/lineages/raw}
Contains Ordnance Survey data © Crown copyright and database right 2019
Contains UK Health Security Agency data © Crown copyright and database right 2020
Office for National Statistics licensed under the Open Government Licence v.3.0
}
\usage{
data("covid_variants_ltla")
}
\description{
Counts of COVID-19 variants from the COGUK COVID-19 sequencing project.
Positive samples were selected based on viral load on initial PCR testing and
sent onward for testing. Prioritisation and over-sampling of cases with S-gene
target failure happened so this data is not unbiased.
}
\details{
Weekly counts of identified variants by Lower tier local authority (2019 names)
This dataset has implicit zeros. The full range of areas can be got from the
\code{geography} data set with: \code{geography \%>\% dplyr::filter(codeType == "LAD19")}

From late March 2023 onward, due to the low number of sequenced samples, the
UK SARS-CoV-2 sequencing surveillance data is not updated on the Wellcome
Sanger Institute COVID-19 Genomic surveillance dashboard. Due to changes
since the end of mass COVID-19 testing in the UK since April 2022 - the
Wellcome Sanger Institute COVID-19 Genomic surveillance dashboard only
includes a subset of UK SARS-CoV-2 sequencing surveillance data and should
not be used to estimate frequency of SARS-CoV-2 variants circulating. Not all
samples sequenced and deposited in public databases are presented here. This
data is not de-duplicated on a patient level - and may include targeted
sequencing that may introduce biases.
\subsection{\code{covid_variants_ltla} dataframe with 55785 rows and 8 columns}{

\describe{
\item{ \code{date} (date) }{
The date - unclear if this was of the sample or result
}
\item{ \code{code} (chr) }{
The ONS geographical region code
}
\item{ \code{codeType} (chr) }{
The type of ONS geographical code
}
\item{ \code{name} (chr) }{
The ONS geographical region name
}
\item{ \code{who_class} (fct) }{
The WHO short name
}
\item{ \code{count} (dbl) }{
The number of sequences of this variant identified on this date
}
\item{ \code{denom} (dbl) }{
The total number of sequences of all variants identified on this date
}
}
}
}
\examples{
dplyr::glimpse(covid_variants_ltla)

}
\concept{datasets}
\keyword{datasets}
