% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_file.R
\name{show_file}
\alias{show_file}
\title{Display the contents of a text file that match a pattern}
\usage{
show_file(path, start = 1, end = NULL, pattern = NULL, chunk = "None")
}
\arguments{
\item{path}{A character vector representing the path to the text file.}

\item{start}{An integer specifying the starting row number (inclusive) to consider. Default is 1.
If negative, it represents the number of lines to print from the end of the file.
If 0, prints the entire file.}

\item{end}{An integer specifying the ending row number (inclusive) to consider. Default is the last row.}

\item{pattern}{A regular expression pattern to match against each row. Default is NULL (no pattern matching).}

\item{chunk}{A character string indicating what content to extract.
Possible values are "None" (default - no chunk processing),
"All" (print all R code chunks), "Last" (print only the last R code chunk),
or "YAML" (extract the YAML header without delimiters).}
}
\value{
The function prints the contents of the specified range of rows that match the pattern (if provided),
the code lines within R code chunks (if chunk is "All" or "Last"),
or the YAML header content (if chunk is "YAML") to the console. If no rows match the pattern,
nothing is printed. If start is negative, the function prints the last abs(start) lines, ignoring
missing lines at the end of the file. If start is 0, the function prints the entire file.
}
\description{
This function reads the contents of a text file and either prints the specified range of rows
that match a given regular expression pattern, prints the code lines within R code chunks,
or extracts the YAML header. If start is a negative number, it prints the last abs(start) lines,
ignoring missing lines at the end of the file. If start is 0, it prints the entire file.
}
\examples{
\dontrun{
# Display all rows of a text file
show_file("path/to/your/file.txt")

# Display the entire file
show_file("path/to/your/file.txt", start = 0)

# Display rows 5 to 10 of a text file
show_file("path/to/your/file.txt", start = 5, end = 10)

# Display all rows of a text file that contain the word "example"
show_file("path/to/your/file.txt", pattern = "example")

# Print all code lines within R code chunks
show_file("path/to/your/file.txt", chunk = "All")

# Print only the last R code chunk
show_file("path/to/your/file.txt", chunk = "Last")

# Extract the YAML header
show_file("path/to/your/file.Rmd", chunk = "YAML")

# Display the last 5 lines of a text file, ignoring missing lines at the end
show_file("path/to/your/file.txt", start = -5)
}

}
