% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-selection.R
\name{choose_metric}
\alias{choose_metric}
\alias{check_metric_in_tune_results}
\alias{choose_eval_time}
\alias{maybe_choose_eval_time}
\alias{first_metric}
\alias{first_eval_time}
\alias{.filter_perf_metrics}
\alias{check_metrics_arg}
\alias{check_eval_time_arg}
\title{Tools for selecting metrics and evaluation times}
\usage{
choose_metric(x, metric, ..., call = rlang::caller_env())

check_metric_in_tune_results(mtr_info, metric, ..., call = rlang::caller_env())

choose_eval_time(
  x,
  metric,
  ...,
  eval_time = NULL,
  quietly = FALSE,
  call = rlang::caller_env()
)

maybe_choose_eval_time(x, mtr_set, eval_time)

first_metric(mtr_set)

first_eval_time(
  mtr_set,
  ...,
  metric = NULL,
  eval_time = NULL,
  quietly = FALSE,
  call = rlang::caller_env()
)

.filter_perf_metrics(x, metric, eval_time)

check_metrics_arg(mtr_set, wflow, ..., call = rlang::caller_env())

check_eval_time_arg(eval_time, mtr_set, ..., call = rlang::caller_env())
}
\arguments{
\item{x}{An object with class \code{tune_results}.}

\item{metric}{A character value for which metric is being used.}

\item{...}{These dots are for future extensions and must be empty.}

\item{call}{The call to be displayed in warnings or errors.}

\item{eval_time}{An optional vector of times to compute dynamic and/or
integrated metrics.}

\item{quietly}{Logical. Should warnings be muffled?}

\item{mtr_set}{A \code{\link[yardstick:metric_set]{yardstick::metric_set()}}.}

\item{wflow}{A \code{\link[workflows:workflow]{workflows::workflow()}}.}
}
\description{
Tools for selecting metrics and evaluation times
}
\details{
These are developer-facing functions used to compute and validate choices
for performance metrics. For survival analysis models, there are similar
functions for the evaluation time(s) required for dynamic and/or integrated
metrics.

\code{choose_metric()} is used with functions such as \code{\link[=show_best]{show_best()}} or
\code{\link[=select_best]{select_best()}} where a single valid metric is required to rank models. If
no value is given by the user, the first metric value is used (with a
warning).

For evaluation times, one is only required when the metric type is dynamic
(e.g. \code{\link[yardstick:brier_survival]{yardstick::brier_survival()}} or \code{\link[yardstick:roc_auc_survival]{yardstick::roc_auc_survival()}}). For
these metrics, we require a single numeric value that was originally given
to the function used to produce \code{x} (such as \code{\link[=tune_grid]{tune_grid()}}).

If a time is required and none is given, the first value in the vector
originally given in the \code{eval_time} argument is used (with a warning).

\code{maybe_choose_eval_time()} is for cases where multiple evaluation times are
acceptable but you need to choose a good default. The "maybe" is because
the function that would use \code{maybe_choose_eval_time()} can accept multiple
metrics (like \code{\link[=autoplot]{autoplot()}}).
}
\keyword{internal}
