% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{GDTE.calculator}
\alias{GDTE.calculator}
\title{Generate the General Dynamic Treatment Effect (GDTE) for an autoregressive distributed lag (ADL) model, given Pulse Treatment Effects (PTEs)}
\usage{
GDTE.calculator(d.x, d.y, h, limit, pte)
}
\arguments{
\item{d.x}{the order of differencing of the x variable in the ADL model. (Generally, this is the same x variable used in \code{pte.calculator})}

\item{d.y}{the order of differencing of the y variable in the ADL model. (Generally, this is the same y variable used in \code{pte.calculator})}

\item{h}{an integer for the treatment history. \code{h} determines the counterfactual series that will be applied to the independent variable. -1 represents a Pulse Treatment Effect (PTE). 0 represents a Step Treatment Effect (STE). For others, see Vande Kamp, Jordan, and Rajan}

\item{limit}{an integer for the number of periods (s) to determine the GDTE (beginning at 0)}

\item{pte}{a list of PTEs used to construct the GDTE. We expect this will be provided by \code{pte.calculator}}
}
\value{
a list of \code{limit} + 1 \code{mpoly} formulae containing the GDTE in each period
}
\description{
Generate the General Dynamic Treatment Effect (GDTE) for an autoregressive distributed lag (ADL) model, given Pulse Treatment Effects (PTEs)
}
\details{
\code{GDTE.calculator} does no calculation. It generates a list of \code{mpoly} formulae that contain variable names that represent the GDTE in each period. The expectation is that these will be evaluated using coefficients from an object containing an ADL model with corresponding variables. It is used as a subfunction in both \code{GDTE.adl.plot} and \code{GDTE.gecm.plot}. Note: \code{mpoly} does not allow variable names with a .; variables passed to \code{GDTE.calculator} should not include this character
}
\examples{
# ADL(1,1)
x.lags <- c("x" = 0, "l_1_x" = 1) # lags of x
y.lags <- c("l_1_y" = 1)
s <- 5
PTEs <- pte.calculator(x.vrbl = x.lags, y.vrbl = y.lags, limit = s)
# Assume that both x and y are in levels and we want a pulse treatment
GDTEs.pte <- GDTE.calculator(d.x = 0, d.y = 0, h = -1, limit = s, pte = PTEs)
GDTEs.pte
# Apply a step treatment
GDTEs.ste <- GDTE.calculator(d.x = 0, d.y = 0, h = 0, limit = s, pte = PTEs)
GDTEs.ste
}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshi Rajan
}
\keyword{utilities}
