
### ePolr model illustration:
### M. Muri, A. Curt, J. Steeves, T. Hothorn
### Baseline-adjusted Proportional Odds Models for the Quantification
### of Treatment Effects in Trials with Ordinal Sum Score Outcomes

SCI_OR_3 <-
structure(list(UEMS3n_int = c(40.4573439161333, 31.411663761801, 
41.7972382719063, 23.1553903051266, 42.7085644196872, 35.5135970742987, 
22.8752561651731, 20.9597155131441, 23.5008998327139, 18.9073711804462, 
39.5960963297965, 37.5165222168709, 27.8751245280787, 3.50598752378517, 
37.3649413158921, 38.4368752056314, 10.6516002022573, 17.3548819521252, 
32.726918605246, 32.5626529220512, 37.6989452284063, 7.24645677813434, 
32.4696904829107, 17.7558163276906, 36.2418235581318, 41.7158248321777, 
41.3630540230236, 0.89083030684595, 39.7401113045943, 45.1638728916303, 
37.5641545273584, 4.27172874489807, 21.6262352659592, 0.902785713967731, 
8.59023081902642, 7.17207714812099, 47.8117612540145, 15.4656954488753, 
18.5513592299978, 9.33513890812312, 0.13398399164557, 13.3915537781345, 
23.705026029777, 37.9917505747642, 14.8190661414213, 26.7305514425041, 
20.5043862814469, 44.3117043208597, 38.8808015425609, 16.8106445766713, 
25.7426738146424, 27.3497901397526, 5.00807551557004, 0.884554576608727, 
2.46277685394867, 29.0416490303955, 37.1363373952441, 3.39795821497383, 
12.9194127543671, 40.5586131380284, 22.5069985296893, 45.8422432626256, 
37.8705685476503, 16.0975858398154, 45.5220653779964, 0.402276488230909, 
45.7010509259583, 23.2545375030149, 39.3494773415573, 7.14511331887091, 
17.6584141541829, 47.3926892258128, 30.0002370281488, 42.2886752505632, 
20.1306854229913, 21.8401565967386, 36.2289214340963, 15.6708478094773, 
5.15645463208759, 7.29738162442036, 43.0720746043791, 9.38405733947114, 
46.7380846968482, 42.6039204703129, 35.6541377677631, 26.249679189685, 
7.75142231785659, 10.7080548916814, 9.20220646055447, 12.1456357000108, 
8.33985152206293, 9.22549002905876, 40.2556034772379, 48.5539241497969, 
29.0704908428866, 16.7839602713695, 40.3745094377339, 38.8567957099934, 
0.0417246296995832, 31.0853046869306, 49.95291120003, 17.7077714175145, 
29.3286707648472, 8.2103329831924, 26.2514228680424, 20.4699058047072, 
44.5734428679713, 4.01409661804842, 36.0601945288338, 48.6509421415248, 
43.8645230904088, 35.9323749499075, 45.5145410464221, 22.6492563984273, 
36.4956260367846, 30.2908018740863, 43.5875164020274, 9.54988045551186, 
42.1809723998159, 48.6896423525597, 36.1316016941123, 0.237668709996052, 
42.1719817101376, 38.0803269053889, 46.4898244671845, 0.256212883598511, 
5.26992725150845, 14.6499718609171, 21.2047486169188, 13.5371885011177, 
42.279802641335, 20.1686935370395, 19.1458613011771, 22.9401271287048, 
49.0619334668345, 17.948452639104, 43.5797788564817, 18.2624390667315, 
37.3947540027547, 35.6451093511415, 32.9304412117795, 48.2873952332339, 
23.7443466158386, 27.9643265290116, 32.1581506076369, 48.0743896999084, 
12.7290003063907, 35.7725961102661, 42.9598778771309, 0.603625342020357, 
5.37829442817039, 0.689319214268016, 33.5949448155072, 12.586228298949, 
18.7881128848315, 28.9659151005876, 41.5946082051513, 47.3989243969623, 
4.9270292145416, 49.604036323562, 40.8328741523073, 31.0182231683659, 
50, 35.6401800265139, 42.9635548938913, 22.8285114222951, 45.3393051708581, 
15.4758019803826, 47.2401509544541, 25.8891931834478, 48.3547950906812, 
44.5176724878315, 48.469627891905, 21.0389032142798, 18.3094825049176, 
27.5400065616552, 7.85217259941328, 37.9270344032318, 18.196993953865, 
19.3803804895583, 47.3808153828769, 3.5384357228437, 42.784063199852, 
47.7324459424557, 20.5851475128032, 19.7881499683662, 27.0552786911715, 
37.8616501991111, 22.952192098898, 18.8839129788196, 23.2229175582156, 
30.3760304298742, 36.0657260898468, 18.8373550243785, 41.1319659376041, 
0.478790864048866, 34.891506519929, 24.4672540963306, 37.3505905758493, 
50, 39.9668315703571, 28.8290270926009, 37.5392802355246, 40.9818548813839, 
43.415775049294, 9.36557759372575, 36.7582919481603, 43.6960279657916, 
2.55303864053675, 50, 7.81443880569454, 43.1276176174451, 50, 
5.52498671829906, 45.5112402277523, 43.8206441565585, 44.7512916648231, 
34.5671757359051, 32.5935481170395, 28.6703963406428, 44.5403340373364, 
38.2968462585301, 13.2616444569415, 2.19910335582278, 28.6644741462075, 
40.0169013672703, 17.3332260909223, 18.5368574066792, 35.8480340500887, 
45.9338988611304, 6.95135429147699, 12.1025099117283, 0.133190046629374, 
18.5001275847203, 6.9155947117172, 43.0456129723293, 45.9589650983102, 
13.222342658474, 39.4591739158448, 39.3696586935731), segblw_s = structure(c(3L, 
1L, 2L, 2L, 3L, 3L, 3L, 3L, 2L, 2L, 3L, 3L, 2L, 3L, 1L, 1L, 3L, 
3L, 1L, 3L, 3L, 3L, 1L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 
3L, 3L, 3L, 3L, 2L, 2L, 3L, 3L, 2L, 2L, 2L, 2L, 3L, 3L, 2L, 3L, 
2L, 1L, 3L, 3L, 3L, 3L, 1L, 3L, 3L, 3L, 2L, 2L, 2L, 2L, 1L, 3L, 
3L, 2L, 2L, 2L, 3L, 3L, 3L, 1L, 1L, 1L, 2L, 2L, 3L, 3L, 3L, 3L, 
3L, 1L, 1L, 1L, 1L, 3L, 3L, 3L, 3L, 3L, 3L, 2L, 2L, 2L, 2L, 3L, 
3L, 3L, 1L, 1L, 2L, 1L, 3L, 2L, 2L, 3L, 3L, 3L, 2L, 2L, 3L, 3L, 
2L, 1L, 1L, 1L, 3L, 2L, 2L, 1L, 3L, 1L, 1L, 2L, 3L, 3L, 3L, 3L, 
3L, 3L, 2L, 3L, 3L, 2L, 3L, 1L, 1L, 3L, 3L, 3L, 1L, 3L, 3L, 1L, 
2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 3L, 2L, 2L, 2L, 2L, 3L, 3L, 1L, 
3L, 3L, 2L, 2L, 3L, 3L, 3L, 3L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 3L, 
2L, 2L, 3L, 3L, 3L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 3L, 2L, 
3L, 3L, 3L, 1L, 2L, 2L, 2L, 1L, 1L, 3L, 3L, 3L, 3L, 2L, 3L, 3L, 
3L, 3L, 1L, 1L, 3L, 3L, 3L, 3L, 1L, 1L, 1L, 3L, 3L, 3L, 3L, 2L, 
2L, 2L, 3L, 3L, 3L, 3L, 3L, 3L, 2L, 3L, 1L, 1L, 2L, 3L, 3L), .Label = c("(-1,6]", 
"(6,8]", "(8,10]"), class = "factor"), UEMS0 = c(3, 28, 18, 18, 
17, 17, 7, 18, 19, 19, 25, 25, 10, 3, 25, 25, 0, 0, 18, 24, 2, 
2, 21, 5, 10, 19, 19, 0, 8, 4, 4, 0, 0, 0, 0, 0, 0, 7, 7, 0, 
0, 8, 8, 8, 6, 8, 8, 28, 2, 9, 17, 22, 0, 0, 0, 20, 2, 0, 0, 
23, 23, 16, 16, 17, 20, 0, 12, 12, 20, 4, 4, 4, 18, 18, 18, 23, 
23, 7, 3, 3, 17, 5, 20, 20, 20, 20, 6, 5, 4, 4, 1, 1, 16, 17, 
17, 17, 10, 12, 0, 27, 27, 14, 17, 3, 20, 10, 0, 0, 13, 26, 26, 
12, 17, 16, 22, 22, 22, 5, 28, 28, 28, 2, 26, 26, 11, 0, 0, 4, 
4, 4, 22, 18, 9, 9, 28, 15, 25, 25, 3, 8, 8, 28, 6, 1, 26, 27, 
12, 6, 26, 0, 0, 0, 7, 7, 13, 28, 20, 20, 0, 0, 27, 20, 16, 19, 
24, 12, 19, 7, 7, 17, 17, 17, 25, 9, 9, 7, 4, 12, 12, 2, 18, 
4, 16, 16, 9, 11, 14, 25, 22, 16, 11, 6, 14, 11, 11, 0, 26, 14, 
14, 21, 27, 27, 24, 12, 12, 8, 21, 26, 0, 8, 4, 23, 23, 7, 22, 
22, 22, 24, 24, 24, 13, 13, 0, 0, 28, 10, 9, 8, 8, 7, 0, 0, 0, 
18, 4, 28, 28, 7, 13, 13), trtmt = structure(c(2L, 1L, 2L, 1L, 
2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 
2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 
2L, 1L, 2L, 1L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 
1L, 1L, 1L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 
2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 2L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 
1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 
2L, 2L, 1L, 1L, 1L, 1L, 2L, 1L, 1L, 2L, 1L, 2L, 1L, 1L, 2L, 1L, 
1L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 2L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 
1L, 2L, 1L, 1L, 2L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 1L, 
2L, 1L, 1L, 1L, 2L, 1L, 2L, 1L, 2L, 1L, 2L, 2L, 1L, 1L, 2L, 2L, 
1L, 1L, 2L, 2L, 2L, 1L, 2L, 2L, 2L, 2L, 2L, 2L, 1L, 2L, 1L, 1L, 
2L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 1L, 1L, 1L, 2L, 1L, 
1L, 2L, 2L, 2L, 1L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 
2L, 2L, 2L, 2L, 2L, 1L, 1L, 2L, 2L, 2L, 1L, 1L, 1L, 1L, 2L, 2L, 
2L, 2L, 1L, 1L, 2L, 2L, 1L, 1L, 1L, 1L, 1L, 2L), .Label = c("N", 
"Y"), class = "factor")), class = "data.frame", row.names = c(NA, 
-240L))

library("tram")

### Model estimation
modUEMS <- Colr(UEMS3n_int | 0 + segblw_s + UEMS0:segblw_s ~ trtmt,
                data = SCI_OR_3,
                support = c(0, 50),
                bounds = c(0, 50))

### log odds ratio of control versus treatment group
coef(modUEMS)

### OR with confidence interval of treatment versus control group
round(c(exp(-coef(modUEMS)),
        "2.5 %" = c(exp(-confint(modUEMS)))[2],
        "97.5 %" = c(exp(-confint(modUEMS)))[1]), 3)
