% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_markdown.R
\name{theme_markdown}
\alias{theme_markdown}
\title{Markdown theme with optional ANSI color support and grid customization}
\usage{
theme_markdown(
  x,
  ansi = FALSE,
  style = NULL,
  vline = NULL,
  hline = NULL,
  hline_header = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{tinytable} object.}

\item{ansi}{Logical. If TRUE, enables ANSI color codes for grid styling. Default is FALSE.}

\item{style}{Character. Markdown style format. Can be "grid" or "gfm". Default is NULL.}

\item{vline}{Logical. Enable/disable vertical lines. Default is TRUE.}

\item{hline}{Logical. Enable/disable horizontal lines. Default is TRUE.}

\item{hline_header}{Logical. Enable/disable the special header separator line below column names. Default is TRUE.}

\item{...}{Additional arguments (ignored).}
}
\value{
A modified \code{tinytable} object.
}
\description{
Markdown theme with optional ANSI color support and grid customization
}
\details{
When \code{ansi = TRUE}, colors and text styling (bold, italic, strikeout, underline)
are applied using ANSI escape sequences for terminal display. ANSI colors require
a terminal or application that supports ANSI escape sequences. Common supported
terminals include: Terminal.app (macOS), iTerm2 (macOS), Windows Terminal, most
Linux terminals, RStudio Console, and VS Code terminal. Colors may not display
correctly in basic text editors or older terminals.
}
