% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dodge.R
\name{dodge_positions}
\alias{dodge_positions}
\title{Dodge positions for grouped data}
\usage{
dodge_positions(
  datapoints,
  dodge,
  fixed.dodge = TRUE,
  cols = NULL,
  settings = NULL
)
}
\arguments{
\item{datapoints}{Data frame containing plot data with at least \code{x} and \code{by}
columns.}

\item{dodge}{Adjustment parameter for dodging overlapping points or ranges in
grouped plots along the x-axis (or y-axis for flipped plots). Either:
\itemize{
\item numeric value in the range \verb{[0,1)}. Note that values are scaled
relative to the spacing of x-axis breaks, e.g. \code{dodge = 0.1} places the
outermost groups one-tenth of the way to adjacent breaks, \code{dodge = 0.5}
places them midway between breaks, etc. Values < 0.5 are recommended.
\item logical. If \code{TRUE}, the dodge width is calculated automatically based on
the number of groups (0.1 per group for 2-4 groups, 0.45 for 5+ groups). If
\code{FALSE} or 0, no dodging is performed.
}

Default value is 0 (no dodging). While we do not check, it is \emph{strongly}
recommended that dodging only be used in cases where the x-axis comprises a
limited number of discrete breaks.}

\item{fixed.dodge}{Logical. If \code{FALSE} (default), dodge positions are
calculated independently for each \code{x} value, based only on the groups
present at that position. If \code{TRUE}, dodge positions are based on all
groups, ensuring "fixed" spacing across x-axis breaks (i.e., even if some
groups are missing for a particular \code{x} value).}

\item{cols}{Character vector of column names to dodge. If \code{NULL} (default),
automatically detects and dodges \code{x}, \code{xmin}, and \code{xmax} if they exist.}

\item{settings}{Environment containing plot settings. If \code{NULL} (default),
retrieved from the calling environment.}
}
\value{
Modified \code{datapoints} data frame with dodged positions.
}
\description{
Adjusts x-coordinates (and optionally xmin/xmax) to dodge overlapping points
or ranges in grouped plots.
}
\details{
When \code{fixed.dodge = TRUE}, all groups are dodged by the same amount across all
x values, which is useful when x is categorical. When \code{fixed.dodge = FALSE},
dodging is calculated independently for each x value, which is useful when
the number of groups varies across x values.

If \code{cols} is not specified, the function automatically dodges \code{x} and any
\code{xmin}/\code{xmax} columns that exist in the data.
}
\keyword{internal}
