% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_barplot.R
\name{type_barplot}
\alias{type_barplot}
\title{Barplot type}
\usage{
type_barplot(
  width = 5/6,
  beside = FALSE,
  center = FALSE,
  FUN = NULL,
  xlevels = NULL,
  xaxlabels = NULL,
  drop.zeros = FALSE
)
}
\arguments{
\item{width}{numeric, optional vector of bar widths. (The distance between
the midpoints of the bars is always 1.)}

\item{beside}{logical. In case of a \code{by} grouping variable, should bars be
juxtaposed? Default is to use stacked bars instead.}

\item{center}{logical or numeric. In case of stacked barplots (\code{beside = FALSE})
should the bars be centered (or all start at zero, default)? If set to
\code{TRUE} the center is at the mid-point of the middle category (in case of
uneven number of categories) or between the two middle categories (in case
of an even number). Additionally it is possible to set \code{center = 2} or
\code{center = 2.5} to indicate that centering should be after the second category
or the mid-way in the third category, respectively.}

\item{FUN}{a function to compute the summary statistic for \code{y} within each
group of \code{x} in case of using a two-sided formula \code{y ~ x} (default: mean).}

\item{xlevels}{a character or numeric vector specifying the ordering of the
levels of the \code{x} variable (if character) or the corresponding indexes
(if numeric) for the plot.}

\item{xaxlabels}{a character vector with the axis labels for the \code{x} variable,
defaulting to the levels of \code{x}.}

\item{drop.zeros}{logical. Should bars with zero height be dropped? If set
to \code{FALSE} (default) a zero height bar is still drawn for which the border
lines will still be visible.}
}
\description{
Type function for producing barplots. For formulas of type
\code{~ x} (without left-hand side) the barplot visualizes the counts (absolute
frequencies) of the levels of \code{x}. For formulas of type \code{y ~ x} the value
of \code{y} within each level of \code{x} is visualized, if necessary aggregated
using some function (default: mean).
}
\examples{
# Basic examples of frequency tables (without y variable)
tinyplot(~ cyl, data = mtcars, type = "barplot")
tinyplot(~ cyl | vs, data = mtcars, type = "barplot")
tinyplot(~ cyl | vs, data = mtcars, type = "barplot", beside = TRUE)
tinyplot(~ cyl | vs, data = mtcars, type = "barplot", beside = TRUE, fill = 0.2)

# Reorder x variable categories either by their character levels or numeric indexes
tinyplot(~ cyl, data = mtcars, type = "barplot", xlevels = c("8", "6", "4"))
tinyplot(~ cyl, data = mtcars, type = "barplot", xlevels = 3:1)

# Note: Above we used automatic argument passing for `beside`. But this
# wouldn't work for `width`, since it would conflict with the top-level
# `tinyplot(..., width = <width>)` argument. It's safer to pass these args
# through the `type_barplot()` functional equivalent.
tinyplot(~ cyl | vs, data = mtcars, fill = 0.2,
  type = type_barplot(beside = TRUE, drop.zeros = TRUE, width = 0.65))

tinytheme("clean2")

# Example for numeric y aggregated by x (default: FUN = mean) + facets
tinyplot(extra ~ ID | group, facet = "by", data = sleep,
  type = "barplot", fill = 0.6)

# Fancy frequency table:
tinyplot(Freq ~ Sex | Survived, facet = ~ Class, data = as.data.frame(Titanic),
  type = "barplot", facet.args = list(nrow = 1), flip = TRUE, fill = 0.6)

# Centered barplot for conditional proportions of hair color (black/brown vs.
# red/blond) given eye color and sex
tinytheme("clean2", palette.qualitative = c("black", "sienna", "indianred", "goldenrod"))
hec = as.data.frame(proportions(HairEyeColor, 2:3))
tinyplot(Freq ~ Eye | Hair, facet = ~ Sex, data = hec, type = "barplot",
  center = TRUE, flip = TRUE, facet.args = list(ncol = 1), yaxl = "percent")

tinytheme()

}
