% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/last_frost_day.R
\name{last_frost_day}
\alias{last_frost_day}
\title{Calculate the last frost day}
\usage{
last_frost_day(
  .data,
  threshold = weather_options$get("extreme.frost_threshold"),
  hemisphere = "south",
  require_full_year = weather_options$get("require_full_year")
)
}
\arguments{
\item{.data}{A data frame or tibble containing daily minimum temperatures in a column named "mint".}

\item{threshold}{The stress temperature threshold for frost (default: 0)}

\item{hemisphere}{Hemisphere indicator: "south" or "north" (default: "south").
If latitude information is available in the data, it will be used to determine the hemisphere.}

\item{require_full_year}{Logical. If TRUE, requires exactly 365 or 366 days (default: TRUE)}
}
\value{
An data.frame or tibble representing the day of year for the last frost, or NA if no frost occurs
}
\description{
This function calculates the last frost day from a numeric vector of daily
minimum temperatures using tidyverse principles.
}
\examples{
file <- system.file("extdata/ppd_72150.met", package = "tidyweather")
records <- read_weather(file)
records |>
    dplyr::group_by(year) |>
    last_frost_day(require_full_year = FALSE)
}
